/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appconfigdata.AppConfigDataClient;
import software.amazon.awssdk.services.appconfigdata.AppConfigDataClientBuilder;
import software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationRequest;
import software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse;
import software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest;
import software.amazon.lambda.powertools.parameters.BaseProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;

public class AppConfigProvider
extends BaseProvider {
    private final AppConfigDataClient client;
    private final String application;
    private final String environment;
    private final HashMap<String, EstablishedSession> establishedSessions = new HashMap();

    AppConfigProvider(CacheManager cacheManager, AppConfigDataClient client, String environment, String application) {
        super(cacheManager);
        this.client = client;
        this.application = application;
        this.environment = environment;
    }

    @Override
    protected String getValue(String key) {
        EstablishedSession establishedSession = this.establishedSessions.getOrDefault(key, null);
        String sessionToken = establishedSession != null ? establishedSession.nextSessionToken : this.client.startConfigurationSession((StartConfigurationSessionRequest)StartConfigurationSessionRequest.builder().applicationIdentifier(this.application).environmentIdentifier(this.environment).configurationProfileIdentifier(key).build()).initialConfigurationToken();
        GetLatestConfigurationResponse response = this.client.getLatestConfiguration((GetLatestConfigurationRequest)GetLatestConfigurationRequest.builder().configurationToken(sessionToken).build());
        String nextSessionToken = response.nextPollConfigurationToken();
        String value = response.configuration() != null ? response.configuration().asUtf8String() : (establishedSession != null ? establishedSession.lastConfigurationValue : null);
        this.establishedSessions.put(key, new EstablishedSession(nextSessionToken, value));
        return value;
    }

    @Override
    protected Map<String, String> getMultipleValues(String path) {
        throw new RuntimeException("Retrieving multiple parameter values is not supported with the AWS App Config Provider");
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private AppConfigDataClient client;
        private CacheManager cacheManager;
        private TransformationManager transformationManager;
        private String environment;
        private String application;

        Builder() {
        }

        public AppConfigProvider build() {
            if (this.cacheManager == null) {
                throw new IllegalStateException("No CacheManager provided; please provide one");
            }
            if (this.environment == null) {
                throw new IllegalStateException("No environment provided; please provide one");
            }
            if (this.application == null) {
                throw new IllegalStateException("No application provided; please provide one");
            }
            if (this.client == null) {
                AppConfigDataClientBuilder appConfigDataClientBuilder = (AppConfigDataClientBuilder)((AppConfigDataClientBuilder)AppConfigDataClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).region(Region.of((String)System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable())));
                String initializationType = System.getenv().get("AWS_LAMBDA_INITIALIZATION_TYPE");
                if (initializationType != null && initializationType.equals("on-demand")) {
                    appConfigDataClientBuilder.credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create());
                }
                this.client = (AppConfigDataClient)appConfigDataClientBuilder.build();
            }
            AppConfigProvider provider = new AppConfigProvider(this.cacheManager, this.client, this.environment, this.application);
            if (this.transformationManager != null) {
                provider.setTransformationManager(this.transformationManager);
            }
            return provider;
        }

        public Builder withClient(AppConfigDataClient client) {
            this.client = client;
            return this;
        }

        public Builder withEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder withApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder withCacheManager(CacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        public Builder withTransformationManager(TransformationManager transformationManager) {
            this.transformationManager = transformationManager;
            return this;
        }
    }

    private static class EstablishedSession {
        private final String nextSessionToken;
        private final String lastConfigurationValue;

        private EstablishedSession(String nextSessionToken, String value) {
            this.nextSessionToken = nextSessionToken;
            this.lastConfigurationValue = value;
        }
    }
}

