/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.lambda.powertools.parameters.BaseProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;
import software.amazon.lambda.powertools.parameters.transform.Transformer;

public class SSMProvider
extends BaseProvider {
    private final SsmClient client;
    private boolean decrypt = false;
    private boolean recursive = false;

    SSMProvider(CacheManager cacheManager) {
        this(cacheManager, (SsmClient)((SsmClientBuilder)((SsmClientBuilder)((SsmClientBuilder)SsmClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create())).region(Region.of((String)System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable())))).build());
    }

    SSMProvider(CacheManager cacheManager, SsmClient client) {
        super(cacheManager);
        this.client = client;
    }

    @Override
    public String getValue(String key) {
        GetParameterRequest request = (GetParameterRequest)GetParameterRequest.builder().name(key).withDecryption(Boolean.valueOf(this.decrypt)).build();
        return this.client.getParameter(request).parameter().value();
    }

    @Override
    public SSMProvider defaultMaxAge(int maxAge, ChronoUnit unit) {
        super.defaultMaxAge(maxAge, unit);
        return this;
    }

    @Override
    public SSMProvider withMaxAge(int maxAge, ChronoUnit unit) {
        super.withMaxAge(maxAge, unit);
        return this;
    }

    @Override
    public SSMProvider withTransformation(Class<? extends Transformer> transformerClass) {
        super.withTransformation(transformerClass);
        return this;
    }

    public SSMProvider withDecryption() {
        this.decrypt = true;
        return this;
    }

    public SSMProvider recursive() {
        this.recursive = true;
        return this;
    }

    @Override
    protected Map<String, String> getMultipleValues(String path) {
        return this.getMultipleBis(path, null);
    }

    private Map<String, String> getMultipleBis(String path, String nextToken) {
        GetParametersByPathRequest request = (GetParametersByPathRequest)GetParametersByPathRequest.builder().path(path).withDecryption(Boolean.valueOf(this.decrypt)).recursive(Boolean.valueOf(this.recursive)).nextToken(nextToken).build();
        HashMap<String, String> params = new HashMap<String, String>();
        GetParametersByPathResponse res = this.client.getParametersByPath(request);
        if (res.hasParameters()) {
            res.parameters().forEach(parameter -> {
                String name = parameter.name();
                if (name.startsWith(path)) {
                    name = name.replaceFirst(path, "");
                }
                name = name.replaceFirst("/", "");
                params.put(name, parameter.value());
            });
        }
        if (!StringUtils.isEmpty((CharSequence)res.nextToken())) {
            params.putAll(this.getMultipleBis(path, res.nextToken()));
        }
        return params;
    }

    @Override
    protected void resetToDefaults() {
        super.resetToDefaults();
        this.recursive = false;
        this.decrypt = false;
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private SsmClient client;
        private CacheManager cacheManager;
        private TransformationManager transformationManager;

        Builder() {
        }

        public SSMProvider build() {
            if (this.cacheManager == null) {
                throw new IllegalStateException("No CacheManager provided, please provide one");
            }
            SSMProvider provider = this.client != null ? new SSMProvider(this.cacheManager, this.client) : new SSMProvider(this.cacheManager);
            if (this.transformationManager != null) {
                provider.setTransformationManager(this.transformationManager);
            }
            return provider;
        }

        public Builder withClient(SsmClient client) {
            this.client = client;
            return this;
        }

        public Builder withCacheManager(CacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        public Builder withTransformationManager(TransformationManager transformationManager) {
            this.transformationManager = transformationManager;
            return this;
        }
    }
}

