/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters.transform;

import java.lang.reflect.InvocationTargetException;
import software.amazon.lambda.powertools.parameters.exception.TransformationException;
import software.amazon.lambda.powertools.parameters.transform.BasicTransformer;
import software.amazon.lambda.powertools.parameters.transform.Transformer;

public class TransformationManager {
    private Class<? extends Transformer> transformer = null;

    public void setTransformer(Class<? extends Transformer> transformerClass) {
        this.transformer = transformerClass;
    }

    public boolean shouldTransform() {
        return this.transformer != null;
    }

    public String performBasicTransformation(String value) {
        if (this.transformer == null) {
            throw new IllegalStateException("You cannot perform a transformation without Transformer, use the provider.withTransformation() method to specify it.");
        }
        if (!BasicTransformer.class.isAssignableFrom(this.transformer)) {
            throw new IllegalStateException("Wrong Transformer for a String, choose a BasicTransformer.");
        }
        try {
            BasicTransformer basicTransformer = (BasicTransformer)this.transformer.getDeclaredConstructor(new Class[0]).newInstance(null);
            return basicTransformer.applyTransformation(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }

    public <T> T performComplexTransformation(String value, Class<T> targetClass) {
        if (this.transformer == null) {
            throw new IllegalStateException("You cannot perform a transformation without Transformer, use the provider.withTransformation() method to specify it.");
        }
        try {
            Transformer complexTransformer = this.transformer.getDeclaredConstructor(new Class[0]).newInstance(null);
            return complexTransformer.applyTransformation(value, targetClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }
}

