/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.util.Strings;
import software.amazon.lambda.powertools.logging.internal.AbstractJacksonLayoutCopy;
import software.amazon.lambda.powertools.logging.internal.JacksonFactoryCopy;

@Plugin(name="LambdaJsonLayout", category="Core", elementType="layout", printObject=true)
public final class LambdaJsonLayout
extends AbstractJacksonLayoutCopy {
    private static final String DEFAULT_FOOTER = "]";
    private static final String DEFAULT_HEADER = "[";
    static final String CONTENT_TYPE = "application/json";

    private LambdaJsonLayout(Configuration config, boolean locationInfo, boolean properties, boolean encodeThreadContextAsList, boolean complete, boolean compact, boolean eventEol, String headerPattern, String footerPattern, Charset charset, boolean includeStacktrace, boolean stacktraceAsString, boolean includeNullDelimiter, KeyValuePair[] additionalFields, boolean objectMessageAsJsonObject) {
        super(config, new JacksonFactoryCopy.JSON(encodeThreadContextAsList, includeStacktrace, stacktraceAsString, objectMessageAsJsonObject).newWriter(locationInfo, properties, compact), charset, compact, complete, eventEol, null, PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(headerPattern).setDefaultPattern(DEFAULT_HEADER).build(), PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(footerPattern).setDefaultPattern(DEFAULT_FOOTER).build(), includeNullDelimiter, additionalFields);
    }

    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String str = this.serializeToString(this.getHeaderSerializer());
        if (str != null) {
            buf.append(str);
        }
        buf.append(this.eol);
        return this.getBytes(buf.toString());
    }

    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.eol);
        String str = this.serializeToString(this.getFooterSerializer());
        if (str != null) {
            buf.append(str);
        }
        buf.append(this.eol);
        return this.getBytes(buf.toString());
    }

    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("version", "2.0");
        return result;
    }

    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static LambdaJsonLayout createDefaultLayout() {
        return new LambdaJsonLayout((Configuration)new DefaultConfiguration(), false, false, false, false, false, false, DEFAULT_HEADER, DEFAULT_FOOTER, StandardCharsets.UTF_8, true, false, false, null, false);
    }

    @Override
    public Object wrapLogEvent(LogEvent event) {
        Map<String, Object> additionalFieldsMap = this.resolveAdditionalFields(event);
        return new LogEventWithAdditionalFields(event, additionalFieldsMap);
    }

    @Override
    public void toSerializable(LogEvent event, Writer writer) throws IOException {
        if (this.complete && this.eventCount > 0L) {
            writer.append(", ");
        }
        super.toSerializable(event, writer);
    }

    private Map<String, Object> resolveAdditionalFields(LogEvent logEvent) {
        LinkedHashMap<String, Object> additionalFieldsMap = new LinkedHashMap<String, Object>(this.additionalFields.length);
        logEvent.getContextData().forEach((key, value) -> {
            if (Strings.isNotBlank((String)key) && value != null) {
                additionalFieldsMap.put((String)key, value);
            }
        });
        return additionalFieldsMap;
    }

    /* synthetic */ LambdaJsonLayout(Configuration configuration, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string, String string2, Charset charset, boolean bl7, boolean bl8, boolean bl9, KeyValuePair[] keyValuePairArray, boolean bl10, LambdaJsonLayout lambdaJsonLayout) {
        this(configuration, bl, bl2, bl3, bl4, bl5, bl6, string, string2, charset, bl7, bl8, bl9, keyValuePairArray, bl10);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractJacksonLayoutCopy.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LambdaJsonLayout> {
        @PluginBuilderAttribute
        private boolean propertiesAsList;
        @PluginBuilderAttribute
        private boolean objectMessageAsJsonObject;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public LambdaJsonLayout build() {
            boolean encodeThreadContextAsList = this.isProperties() && this.propertiesAsList;
            String headerPattern = this.toStringOrNull(this.getHeader());
            String footerPattern = this.toStringOrNull(this.getFooter());
            return new LambdaJsonLayout(this.getConfiguration(), this.isLocationInfo(), this.isProperties(), encodeThreadContextAsList, this.isComplete(), this.isCompact(), this.getEventEol(), headerPattern, footerPattern, this.getCharset(), this.isIncludeStacktrace(), this.isStacktraceAsString(), this.isIncludeNullDelimiter(), this.getAdditionalFields(), this.getObjectMessageAsJsonObject(), null);
        }

        public boolean isPropertiesAsList() {
            return this.propertiesAsList;
        }

        public B setPropertiesAsList(boolean propertiesAsList) {
            this.propertiesAsList = propertiesAsList;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean getObjectMessageAsJsonObject() {
            return this.objectMessageAsJsonObject;
        }

        public B setObjectMessageAsJsonObject(boolean objectMessageAsJsonObject) {
            this.objectMessageAsJsonObject = objectMessageAsJsonObject;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }

    @JsonRootName(value="Event")
    public static class LogEventWithAdditionalFields {
        private final LogEvent logEvent;
        private final Map<String, Object> additionalFields;

        public LogEventWithAdditionalFields(LogEvent logEvent, Map<String, Object> additionalFields) {
            this.logEvent = logEvent;
            this.additionalFields = additionalFields;
        }

        @JsonUnwrapped
        public Object getLogEvent() {
            return this.logEvent;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonGetter(value="timestamp")
        public String getTimestamp() {
            return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(ZonedDateTime.from(Instant.ofEpochMilli(this.logEvent.getTimeMillis()).atZone(ZoneId.systemDefault())));
        }
    }
}

