/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

final class PowertoolsResolver
implements EventResolver {
    private final EventResolver internalResolver = new EventResolver(){

        public boolean isResolvable(LogEvent value) {
            ReadOnlyStringMap contextData = value.getContextData();
            return contextData != null && !contextData.isEmpty();
        }

        public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
            StringBuilder stringBuilder = jsonWriter.getStringBuilder();
            stringBuilder.setLength(stringBuilder.length() - 4);
            ReadOnlyStringMap contextData = logEvent.getContextData();
            contextData.forEach((key, value) -> {
                jsonWriter.writeSeparator();
                jsonWriter.writeString((CharSequence)key);
                stringBuilder.append(':');
                jsonWriter.writeValue(value);
            });
        }
    };

    PowertoolsResolver() {
    }

    static String getName() {
        return "powertools";
    }

    public void resolve(LogEvent value, JsonWriter jsonWriter) {
        this.internalResolver.resolve((Object)value, jsonWriter);
    }

    public boolean isResolvable(LogEvent value) {
        return this.internalResolver.isResolvable((Object)value);
    }
}

