/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.util.IOUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclarePrecedence;
import org.aspectj.lang.annotation.Pointcut;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.Logging;
import software.amazon.lambda.powertools.logging.LoggingUtils;
import software.amazon.lambda.powertools.logging.internal.DefaultLambdaFields;

@Aspect
@DeclarePrecedence(value="*, SqsLargeMessageAspect, LambdaLoggingAspect")
public final class LambdaLoggingAspect {
    private static final Logger LOG = LogManager.getLogger(LambdaLoggingAspect.class);
    private static final Random SAMPLER = new Random();
    private static final String LOG_LEVEL = System.getenv("POWERTOOLS_LOG_LEVEL");
    private static final String SAMPLING_RATE = System.getenv("POWERTOOLS_LOGGER_SAMPLE_RATE");
    private static Level LEVEL_AT_INITIALISATION;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaLoggingAspect ajc$perSingletonInstance;

    static {
        if (LOG_LEVEL != null) {
            LambdaLoggingAspect.resetLogLevels(Level.getLevel((String)LOG_LEVEL));
        }
        LEVEL_AT_INITIALISATION = LOG.getLevel();
        try {
            LambdaLoggingAspect.ajc$perSingletonInstance = new LambdaLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(logging)")
    public /* synthetic */ void callAt(Logging logging) {
    }

    @Around(value="callAt(logging) && execution(@Logging * *.*(..))", argNames="pjp,logging")
    public Object around(ProceedingJoinPoint pjp, Logging logging) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        this.setLogLevelBasedOnSamplingRate(pjp, logging);
        Context extractedContext = LambdaHandlerProcessor.extractContext((ProceedingJoinPoint)pjp);
        if (extractedContext != null) {
            LoggingUtils.appendKeys(LambdaLoggingAspect.ajc$inlineAccessMethod$software_amazon_lambda_powertools_logging_internal_LambdaLoggingAspect$software_amazon_lambda_powertools_logging_internal_DefaultLambdaFields$values(extractedContext));
            LoggingUtils.appendKey("coldStart", LambdaHandlerProcessor.isColdStart() ? "true" : "false");
            LoggingUtils.appendKey("service", LambdaHandlerProcessor.serviceName());
        }
        LambdaHandlerProcessor.getXrayTraceId().ifPresent(xRayTraceId -> LoggingUtils.appendKey("xray_trace_id", xRayTraceId));
        if (logging.logEvent()) {
            proceedArgs = this.logEvent(pjp);
        }
        if (!logging.correlationIdPath().isEmpty()) {
            proceedArgs = this.captureCorrelationId(logging.correlationIdPath(), pjp);
        }
        Object proceed = pjp.proceed(proceedArgs);
        if (logging.clearState()) {
            ThreadContext.clearMap();
        }
        LambdaHandlerProcessor.coldStartDone();
        return proceed;
    }

    private static void resetLogLevels(Level logLevel) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)logLevel);
        ctx.updateLoggers();
    }

    private void setLogLevelBasedOnSamplingRate(ProceedingJoinPoint pjp, Logging logging) {
        double samplingRate = this.samplingRate(logging);
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            if (samplingRate < 0.0 || samplingRate > 1.0) {
                LOG.debug("Skipping sampling rate configuration because of invalid value. Sampling rate: {}", (Object)samplingRate);
                return;
            }
            LoggingUtils.appendKey("samplingRate", String.valueOf(samplingRate));
            if (samplingRate == 0.0) {
                return;
            }
            float sample = SAMPLER.nextFloat();
            if (samplingRate > (double)sample) {
                LambdaLoggingAspect.resetLogLevels(Level.DEBUG);
                LOG.debug("Changed log level to DEBUG based on Sampling configuration. Sampling Rate: {}, Sampler Value: {}.", (Object)samplingRate, (Object)Float.valueOf(sample));
            } else if (LEVEL_AT_INITIALISATION != LOG.getLevel()) {
                LambdaLoggingAspect.resetLogLevels(LEVEL_AT_INITIALISATION);
            }
        }
    }

    private double samplingRate(Logging logging) {
        if (SAMPLING_RATE != null) {
            try {
                return Double.parseDouble(SAMPLING_RATE);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.debug("Skipping sampling rate on environment variable configuration because of invalid value. Sampling rate: {}", (Object)SAMPLING_RATE);
            }
        }
        return logging.samplingRate();
    }

    private Object[] logEvent(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            if (LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp)) {
                Logger log = this.logger(pjp);
                this.asJson(pjp, pjp.getArgs()[0]).ifPresent(arg_0 -> ((Logger)log).info(arg_0));
            }
            if (LambdaHandlerProcessor.placedOnStreamHandler((ProceedingJoinPoint)pjp)) {
                args = this.logFromInputStream(pjp);
            }
        }
        return args;
    }

    private Object[] captureCorrelationId(String correlationIdPath, ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            if (LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp)) {
                Object arg = pjp.getArgs()[0];
                JsonNode jsonNode = LoggingUtils.objectMapper().valueToTree(arg);
                this.setCorrelationIdFromNode(correlationIdPath, pjp, jsonNode);
                return args;
            }
            if (LambdaHandlerProcessor.placedOnStreamHandler((ProceedingJoinPoint)pjp)) {
                try {
                    byte[] bytes = this.bytesFromInputStreamSafely((InputStream)pjp.getArgs()[0]);
                    JsonNode jsonNode = LoggingUtils.objectMapper().readTree(bytes);
                    args[0] = new ByteArrayInputStream(bytes);
                    this.setCorrelationIdFromNode(correlationIdPath, pjp, jsonNode);
                    return args;
                }
                catch (IOException e) {
                    Logger log = this.logger(pjp);
                    log.warn("Failed to capture correlation id on event from supplied input stream.", (Throwable)e);
                }
            }
        }
        return args;
    }

    private void setCorrelationIdFromNode(String correlationIdPath, ProceedingJoinPoint pjp, JsonNode jsonNode) {
        JsonNode node = jsonNode.at(JsonPointer.compile((String)correlationIdPath));
        String asText = node.asText();
        if (asText != null && !asText.isEmpty()) {
            LoggingUtils.setCorrelationId(asText);
        } else {
            this.logger(pjp).debug("Unable to extract any correlation id. Is your function expecting supported event type?");
        }
    }

    private Object[] logFromInputStream(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        try {
            byte[] bytes = this.bytesFromInputStreamSafely((InputStream)pjp.getArgs()[0]);
            args[0] = new ByteArrayInputStream(bytes);
            Logger log = this.logger(pjp);
            this.asJson(pjp, LoggingUtils.objectMapper().readValue(bytes, Map.class)).ifPresent(arg_0 -> ((Logger)log).info(arg_0));
        }
        catch (IOException e) {
            Logger log = this.logger(pjp);
            log.debug("Failed to log event from supplied input stream.", (Throwable)e);
        }
        return args;
    }

    /*
     * Loose catch block
     */
    private byte[] bytesFromInputStreamSafely(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            byte[] byArray;
            InputStreamReader reader;
            ByteArrayOutputStream out;
            block16: {
                block15: {
                    out = new ByteArrayOutputStream();
                    reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                    IOUtils.copy((Reader)reader, (Writer)writer);
                    writer.flush();
                    byArray = out.toByteArray();
                    if (reader == null) break block15;
                    reader.close();
                }
                if (out == null) break block16;
                out.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (out != null) {
                            out.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Optional<String> asJson(ProceedingJoinPoint pjp, Object target) {
        try {
            return Optional.ofNullable(LoggingUtils.objectMapper().writeValueAsString(target));
        }
        catch (JsonProcessingException e) {
            this.logger(pjp).error("Failed logging event of type {}", target.getClass(), (Object)e);
            return Optional.empty();
        }
    }

    private Logger logger(ProceedingJoinPoint pjp) {
        return LogManager.getLogger((Class)pjp.getSignature().getDeclaringType());
    }

    public static LambdaLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.logging.internal.LambdaLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    public static /* synthetic */ Map ajc$inlineAccessMethod$software_amazon_lambda_powertools_logging_internal_LambdaLoggingAspect$software_amazon_lambda_powertools_logging_internal_DefaultLambdaFields$values(Context context) {
        return DefaultLambdaFields.values(context);
    }
}

