/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.largemessages.internal;

import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.util.Optional;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessor;
import software.amazon.lambda.powertools.largemessages.internal.LargeSNSMessageProcessor;
import software.amazon.lambda.powertools.largemessages.internal.LargeSQSMessageProcessor;

public final class LargeMessageProcessorFactory {
    private LargeMessageProcessorFactory() {
    }

    public static Optional<LargeMessageProcessor<?>> get(Object message) {
        if (message instanceof SQSEvent.SQSMessage) {
            return Optional.of(new LargeSQSMessageProcessor());
        }
        if (message instanceof SNSEvent.SNSRecord) {
            return Optional.of(new LargeSNSMessageProcessor());
        }
        return Optional.empty();
    }
}

