/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.largemessages.internal;

import java.nio.charset.StandardCharsets;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.lambda.powertools.largemessages.LargeMessageConfig;
import software.amazon.lambda.powertools.largemessages.LargeMessageProcessingException;
import software.amazon.payloadoffloading.S3BackedPayloadStore;
import software.amazon.payloadoffloading.S3Dao;

abstract class LargeMessageProcessor<T> {
    protected static final String RESERVED_ATTRIBUTE_NAME = "ExtendedPayloadSize";
    private static final Logger LOG = LoggerFactory.getLogger(LargeMessageProcessor.class);
    private final S3Client s3Client = LargeMessageConfig.get().getS3Client();
    private final S3BackedPayloadStore payloadStore = new S3BackedPayloadStore(new S3Dao(this.s3Client), "DUMMY");

    LargeMessageProcessor() {
    }

    public Object process(ProceedingJoinPoint pjp, boolean deleteS3Object) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        Object message = proceedArgs[0];
        if (!this.isLargeMessage(message)) {
            LOG.warn("Not a large message, proceeding");
            return pjp.proceed(proceedArgs);
        }
        String payloadPointer = this.getMessageContent(message);
        if (payloadPointer == null) {
            LOG.warn("No content in the message, proceeding");
            return pjp.proceed(proceedArgs);
        }
        payloadPointer = payloadPointer.replace("com.amazon.sqs.javamessaging.MessageS3Pointer", "software.amazon.payloadoffloading.PayloadS3Pointer");
        if (LOG.isInfoEnabled()) {
            LOG.info("Large message [{}]: retrieving content from S3", (Object)this.getMessageId(message));
        }
        String s3ObjectContent = this.getS3ObjectContent(payloadPointer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Large message [{}] retrieved in S3 [{}]: {}KB", new Object[]{this.getMessageId(message), payloadPointer, s3ObjectContent.getBytes(StandardCharsets.UTF_8).length / 1024});
        }
        this.updateMessageContent(message, s3ObjectContent);
        this.removeLargeMessageAttributes(message);
        Object response = pjp.proceed(proceedArgs);
        if (deleteS3Object) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Large message [{}]: deleting object from S3", (Object)this.getMessageId(message));
            }
            this.deleteS3Object(payloadPointer);
        }
        return response;
    }

    protected abstract String getMessageId(T var1);

    protected abstract String getMessageContent(T var1);

    protected abstract void updateMessageContent(T var1, String var2);

    protected abstract boolean isLargeMessage(T var1);

    protected abstract void removeLargeMessageAttributes(T var1);

    private String getS3ObjectContent(String payloadPointer) {
        try {
            return this.payloadStore.getOriginalPayload(payloadPointer);
        }
        catch (SdkException e) {
            throw new LargeMessageProcessingException(String.format("Failed processing S3 record [%s]", payloadPointer), e);
        }
    }

    private void deleteS3Object(String payloadPointer) {
        try {
            this.payloadStore.deleteOriginalPayload(payloadPointer);
        }
        catch (SdkException e) {
            throw new LargeMessageProcessingException(String.format("Failed deleting S3 record [%s]", payloadPointer), e);
        }
    }
}

