/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.core.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.lambda.powertools.core.internal.SystemWrapper;

public class UserAgentConfigurator {
    public static final String NA = "NA";
    public static final String VERSION_KEY = "powertools.version";
    public static final String PT_FEATURE_VARIABLE = "${PT_FEATURE}";
    public static final String PT_EXEC_ENV_VARIABLE = "${PT_EXEC_ENV}";
    public static final String VERSION_PROPERTIES_FILENAME = "version.properties";
    public static final String AWS_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentConfigurator.class);
    private static final String NO_OP = "no-op";
    private static String ptVersion = UserAgentConfigurator.getProjectVersion();
    private static String userAgentPattern = "PT/${PT_FEATURE}/" + ptVersion + " PTEnv/" + "${PT_EXEC_ENV}";

    private UserAgentConfigurator() {
        throw new IllegalStateException("Utility class. Not meant to be instantiated");
    }

    static String getProjectVersion() {
        return UserAgentConfigurator.getVersionFromProperties(VERSION_PROPERTIES_FILENAME, VERSION_KEY);
    }

    static String getVersionFromProperties(String propertyFileName, String versionKey) {
        URL propertiesFileURI = Thread.currentThread().getContextClassLoader().getResource(propertyFileName);
        if (propertiesFileURI != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream fis = new FileInputStream(propertiesFileURI.getPath());){
                    Properties properties = new Properties();
                    properties.load(fis);
                    String version = properties.getProperty(versionKey);
                    if (version != null && !version.isEmpty()) {
                        return version;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to read {} file. Using default version.", (Object)propertyFileName);
                LOG.debug("Exception:", (Throwable)e);
            }
        }
        return NA;
    }

    public static String getUserAgent(String ptFeature) {
        String awsExecutionEnv = SystemWrapper.getenv(AWS_EXECUTION_ENV);
        String ptExecEnv = awsExecutionEnv != null ? awsExecutionEnv : NA;
        String userAgent = userAgentPattern.replace(PT_EXEC_ENV_VARIABLE, ptExecEnv);
        if (ptFeature == null || ptFeature.isEmpty()) {
            ptFeature = NO_OP;
        }
        return userAgent.replace(PT_FEATURE_VARIABLE, ptFeature).replace(PT_EXEC_ENV_VARIABLE, ptExecEnv);
    }
}

