/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval.polling;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.KinesisRequestsBuilder;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.AWSExceptionManager;
import software.amazon.kinesis.retrieval.DataFetcherResult;
import software.amazon.kinesis.retrieval.IteratorBuilder;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class KinesisDataFetcher {
    private static final Logger log = LoggerFactory.getLogger(KinesisDataFetcher.class);
    private static final String METRICS_PREFIX = "KinesisDataFetcher";
    private static final String OPERATION = "ProcessTask";
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final String streamName;
    @NonNull
    private final String shardId;
    private final int maxRecords;
    @NonNull
    private final MetricsFactory metricsFactory;
    private String nextIterator;
    private boolean isShardEndReached;
    private boolean isInitialized;
    private String lastKnownSequenceNumber;
    private InitialPositionInStreamExtended initialPositionInStream;
    final DataFetcherResult TERMINAL_RESULT = new DataFetcherResult(){

        @Override
        public GetRecordsResponse getResult() {
            return (GetRecordsResponse)GetRecordsResponse.builder().millisBehindLatest(null).records(Collections.emptyList()).nextShardIterator(null).build();
        }

        @Override
        public GetRecordsResponse accept() {
            KinesisDataFetcher.this.isShardEndReached = true;
            return this.getResult();
        }

        @Override
        public boolean isShardEnd() {
            return KinesisDataFetcher.this.isShardEndReached;
        }
    };

    public DataFetcherResult getRecords() {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("KinesisDataFetcher.records called before initialization.");
        }
        if (this.nextIterator != null) {
            try {
                return new AdvancingResult(this.getRecords(this.nextIterator));
            }
            catch (ResourceNotFoundException e) {
                log.info("Caught ResourceNotFoundException when fetching records for shard {}", (Object)this.shardId);
                return this.TERMINAL_RESULT;
            }
        }
        return this.TERMINAL_RESULT;
    }

    public void initialize(String initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        log.info("Initializing shard {} with {}", (Object)this.shardId, (Object)initialCheckpoint);
        this.advanceIteratorTo(initialCheckpoint, initialPositionInStream);
        this.isInitialized = true;
    }

    public void initialize(ExtendedSequenceNumber initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        log.info("Initializing shard {} with {}", (Object)this.shardId, (Object)initialCheckpoint.sequenceNumber());
        this.advanceIteratorTo(initialCheckpoint.sequenceNumber(), initialPositionInStream);
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceIteratorTo(String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("SequenceNumber should not be null: shardId " + this.shardId);
        }
        AWSExceptionManager exceptionManager = this.createExceptionManager();
        GetShardIteratorRequest.Builder builder = KinesisRequestsBuilder.getShardIteratorRequestBuilder().streamName(this.streamName).shardId(this.shardId);
        GetShardIteratorRequest request = (GetShardIteratorRequest)IteratorBuilder.request(builder, sequenceNumber, initialPositionInStream).build();
        MetricsScope metricsScope = MetricsUtil.createMetricsWithOperation(this.metricsFactory, OPERATION);
        MetricsUtil.addShardId(metricsScope, this.shardId);
        boolean success = false;
        long startTime = System.currentTimeMillis();
        try {
            try {
                GetShardIteratorResponse result = (GetShardIteratorResponse)this.kinesisClient.getShardIterator(request).get();
                this.nextIterator = result.shardIterator();
                success = true;
            }
            catch (ExecutionException e) {
                throw exceptionManager.apply(e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ResourceNotFoundException e) {
            try {
                log.info("Caught ResourceNotFoundException when getting an iterator for shard {}", (Object)this.shardId, (Object)e);
                this.nextIterator = null;
            }
            catch (Throwable throwable) {
                MetricsUtil.addSuccessAndLatency(metricsScope, String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), success, startTime, MetricsLevel.DETAILED);
                MetricsUtil.endScope(metricsScope);
                throw throwable;
            }
            MetricsUtil.addSuccessAndLatency(metricsScope, String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), success, startTime, MetricsLevel.DETAILED);
            MetricsUtil.endScope(metricsScope);
        }
        MetricsUtil.addSuccessAndLatency(metricsScope, String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), success, startTime, MetricsLevel.DETAILED);
        MetricsUtil.endScope(metricsScope);
        if (this.nextIterator == null) {
            this.isShardEndReached = true;
        }
        this.lastKnownSequenceNumber = sequenceNumber;
        this.initialPositionInStream = initialPositionInStream;
    }

    public void restartIterator() {
        if (StringUtils.isEmpty((String)this.lastKnownSequenceNumber) || this.initialPositionInStream == null) {
            throw new IllegalStateException("Make sure to initialize the KinesisDataFetcher before restarting the iterator.");
        }
        this.advanceIteratorTo(this.lastKnownSequenceNumber, this.initialPositionInStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GetRecordsResponse getRecords(@NonNull String nextIterator) {
        GetRecordsResponse getRecordsResponse;
        if (nextIterator == null) {
            throw new NullPointerException("nextIterator");
        }
        AWSExceptionManager exceptionManager = this.createExceptionManager();
        GetRecordsRequest request = (GetRecordsRequest)KinesisRequestsBuilder.getRecordsRequestBuilder().shardIterator(nextIterator).limit(Integer.valueOf(this.maxRecords)).build();
        MetricsScope metricsScope = MetricsUtil.createMetricsWithOperation(this.metricsFactory, OPERATION);
        MetricsUtil.addShardId(metricsScope, this.shardId);
        boolean success = false;
        long startTime = System.currentTimeMillis();
        try {
            GetRecordsResponse response = (GetRecordsResponse)this.kinesisClient.getRecords(request).get();
            success = true;
            getRecordsResponse = response;
        }
        catch (ExecutionException e) {
            try {
                throw exceptionManager.apply(e.getCause());
                catch (InterruptedException e2) {
                    log.debug("Interrupt called on metod, shutdown initiated");
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                MetricsUtil.addSuccessAndLatency(metricsScope, String.format("%s.%s", METRICS_PREFIX, "getRecords"), success, startTime, MetricsLevel.DETAILED);
                MetricsUtil.endScope(metricsScope);
                throw throwable;
            }
        }
        MetricsUtil.addSuccessAndLatency(metricsScope, String.format("%s.%s", METRICS_PREFIX, "getRecords"), success, startTime, MetricsLevel.DETAILED);
        MetricsUtil.endScope(metricsScope);
        return getRecordsResponse;
    }

    private AWSExceptionManager createExceptionManager() {
        AWSExceptionManager exceptionManager = new AWSExceptionManager();
        exceptionManager.add(ResourceNotFoundException.class, t -> t);
        exceptionManager.add(KinesisException.class, t -> t);
        return exceptionManager;
    }

    public KinesisDataFetcher(@NonNull KinesisAsyncClient kinesisClient, @NonNull String streamName, @NonNull String shardId, int maxRecords, @NonNull MetricsFactory metricsFactory) {
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName");
        }
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        this.kinesisClient = kinesisClient;
        this.streamName = streamName;
        this.shardId = shardId;
        this.maxRecords = maxRecords;
        this.metricsFactory = metricsFactory;
    }

    String getNextIterator() {
        return this.nextIterator;
    }

    public boolean isShardEndReached() {
        return this.isShardEndReached;
    }

    class AdvancingResult
    implements DataFetcherResult {
        final GetRecordsResponse result;

        @Override
        public GetRecordsResponse getResult() {
            return this.result;
        }

        @Override
        public GetRecordsResponse accept() {
            KinesisDataFetcher.this.nextIterator = this.result.nextShardIterator();
            if (this.result.records() != null && !this.result.records().isEmpty()) {
                KinesisDataFetcher.this.lastKnownSequenceNumber = ((Record)Iterables.getLast((Iterable)this.result.records())).sequenceNumber();
            }
            if (KinesisDataFetcher.this.nextIterator == null) {
                KinesisDataFetcher.this.isShardEndReached = true;
            }
            return this.getResult();
        }

        @Override
        public boolean isShardEnd() {
            return KinesisDataFetcher.this.isShardEndReached;
        }

        public AdvancingResult(GetRecordsResponse result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdvancingResult)) {
                return false;
            }
            AdvancingResult other = (AdvancingResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GetRecordsResponse this$result = this.getResult();
            GetRecordsResponse other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdvancingResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GetRecordsResponse $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "KinesisDataFetcher.AdvancingResult(result=" + this.getResult() + ")";
        }
    }
}

