/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.retrieval;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.checkpoint.SentinelCheckpoint;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;

@KinesisClientInternalApi
public class IteratorBuilder {
    private static final Map<String, ShardIteratorType> SHARD_ITERATOR_MAPPING;

    public static SubscribeToShardRequest.Builder request(SubscribeToShardRequest.Builder builder, String sequenceNumber, InitialPositionInStreamExtended initialPosition) {
        return builder.startingPosition((StartingPosition)IteratorBuilder.request(StartingPosition.builder(), sequenceNumber, initialPosition).build());
    }

    public static SubscribeToShardRequest.Builder reconnectRequest(SubscribeToShardRequest.Builder builder, String sequenceNumber, InitialPositionInStreamExtended initialPosition) {
        return builder.startingPosition((StartingPosition)IteratorBuilder.reconnectRequest(StartingPosition.builder(), sequenceNumber, initialPosition).build());
    }

    public static StartingPosition.Builder request(StartingPosition.Builder builder, String sequenceNumber, InitialPositionInStreamExtended initialPosition) {
        return IteratorBuilder.apply(builder, StartingPosition.Builder::type, StartingPosition.Builder::timestamp, StartingPosition.Builder::sequenceNumber, initialPosition, sequenceNumber, ShardIteratorType.AT_SEQUENCE_NUMBER);
    }

    public static StartingPosition.Builder reconnectRequest(StartingPosition.Builder builder, String sequenceNumber, InitialPositionInStreamExtended initialPosition) {
        return IteratorBuilder.apply(builder, StartingPosition.Builder::type, StartingPosition.Builder::timestamp, StartingPosition.Builder::sequenceNumber, initialPosition, sequenceNumber, ShardIteratorType.AFTER_SEQUENCE_NUMBER);
    }

    public static GetShardIteratorRequest.Builder request(GetShardIteratorRequest.Builder builder, String sequenceNumber, InitialPositionInStreamExtended initialPosition) {
        return IteratorBuilder.apply(builder, GetShardIteratorRequest.Builder::shardIteratorType, GetShardIteratorRequest.Builder::timestamp, GetShardIteratorRequest.Builder::startingSequenceNumber, initialPosition, sequenceNumber, ShardIteratorType.AT_SEQUENCE_NUMBER);
    }

    private static <R> R apply(R initial, UpdatingFunction<ShardIteratorType, R> shardIterFunc, UpdatingFunction<Instant, R> dateFunc, UpdatingFunction<String, R> sequenceFunction, InitialPositionInStreamExtended initialPositionInStreamExtended, String sequenceNumber, ShardIteratorType defaultIteratorType) {
        ShardIteratorType iteratorType = SHARD_ITERATOR_MAPPING.getOrDefault(sequenceNumber, defaultIteratorType);
        R result = shardIterFunc.apply(initial, iteratorType);
        switch (iteratorType) {
            case AT_TIMESTAMP: {
                return dateFunc.apply(result, initialPositionInStreamExtended.getTimestamp().toInstant());
            }
            case AT_SEQUENCE_NUMBER: 
            case AFTER_SEQUENCE_NUMBER: {
                return sequenceFunction.apply(result, sequenceNumber);
            }
        }
        return result;
    }

    static {
        HashMap<String, ShardIteratorType> map = new HashMap<String, ShardIteratorType>();
        map.put(SentinelCheckpoint.LATEST.name(), ShardIteratorType.LATEST);
        map.put(SentinelCheckpoint.TRIM_HORIZON.name(), ShardIteratorType.TRIM_HORIZON);
        map.put(SentinelCheckpoint.AT_TIMESTAMP.name(), ShardIteratorType.AT_TIMESTAMP);
        SHARD_ITERATOR_MAPPING = Collections.unmodifiableMap(map);
    }

    @FunctionalInterface
    private static interface UpdatingFunction<T, R> {
        public R apply(R var1, T var2);
    }
}

