/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.kinesis.metrics.CloudWatchMetricKey;
import software.amazon.kinesis.metrics.CloudWatchPublisherRunnable;
import software.amazon.kinesis.metrics.FilteringMetricsScope;
import software.amazon.kinesis.metrics.MetricDatumWithKey;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;

public class CloudWatchMetricsScope
extends FilteringMetricsScope
implements MetricsScope {
    private CloudWatchPublisherRunnable publisher;

    public CloudWatchMetricsScope(CloudWatchPublisherRunnable publisher, MetricsLevel metricsLevel, Set<String> metricsEnabledDimensions) {
        super(metricsLevel, metricsEnabledDimensions);
        this.publisher = publisher;
    }

    @Override
    public void end() {
        super.end();
        List<MetricDatumWithKey<CloudWatchMetricKey>> dataWithKeys = this.data.values().stream().map(metricDatum -> (MetricDatum)metricDatum.toBuilder().dimensions(this.getDimensions()).build()).map(metricDatum -> new MetricDatumWithKey<CloudWatchMetricKey>(new CloudWatchMetricKey((MetricDatum)metricDatum), (MetricDatum)metricDatum)).collect(Collectors.toList());
        this.publisher.enqueue(dataWithKeys);
    }
}

