/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.metrics;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import lombok.NonNull;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.kinesis.metrics.CloudWatchMetricsPublisher;
import software.amazon.kinesis.metrics.CloudWatchMetricsScope;
import software.amazon.kinesis.metrics.CloudWatchPublisherRunnable;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;

public class CloudWatchMetricsFactory
implements MetricsFactory {
    private final CloudWatchPublisherRunnable runnable;
    private final Thread publicationThread;
    private final MetricsLevel metricsLevel;
    private final Set<String> metricsEnabledDimensions;

    public CloudWatchMetricsFactory(@NonNull CloudWatchAsyncClient cloudWatchClient, @NonNull String namespace, long bufferTimeMillis, int maxQueueSize, @NonNull MetricsLevel metricsLevel, @NonNull Set<String> metricsEnabledDimensions, int flushSize) {
        if (cloudWatchClient == null) {
            throw new NullPointerException("cloudWatchClient");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace");
        }
        if (metricsLevel == null) {
            throw new NullPointerException("metricsLevel");
        }
        if (metricsEnabledDimensions == null) {
            throw new NullPointerException("metricsEnabledDimensions");
        }
        this.metricsLevel = metricsLevel;
        this.metricsEnabledDimensions = metricsEnabledDimensions == null ? ImmutableSet.of() : ImmutableSet.copyOf(metricsEnabledDimensions);
        this.runnable = new CloudWatchPublisherRunnable(new CloudWatchMetricsPublisher(cloudWatchClient, namespace), bufferTimeMillis, maxQueueSize, flushSize);
        this.publicationThread = new Thread(this.runnable);
        this.publicationThread.setName("cw-metrics-publisher");
        this.publicationThread.start();
    }

    @Override
    public MetricsScope createMetrics() {
        return new CloudWatchMetricsScope(this.runnable, this.metricsLevel, this.metricsEnabledDimensions);
    }

    public void shutdown() {
        this.runnable.shutdown();
        try {
            this.publicationThread.join();
        }
        catch (InterruptedException e) {
            throw AbortedException.builder().message(e.getMessage()).cause((Throwable)e).build();
        }
    }
}

