/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.lifecycle;

import software.amazon.kinesis.lifecycle.BlockOnParentShardTask;
import software.amazon.kinesis.lifecycle.ConsumerState;
import software.amazon.kinesis.lifecycle.ConsumerTask;
import software.amazon.kinesis.lifecycle.InitializeTask;
import software.amazon.kinesis.lifecycle.ProcessTask;
import software.amazon.kinesis.lifecycle.ShardConsumer;
import software.amazon.kinesis.lifecycle.ShardConsumerArgument;
import software.amazon.kinesis.lifecycle.ShutdownNotificationTask;
import software.amazon.kinesis.lifecycle.ShutdownReason;
import software.amazon.kinesis.lifecycle.ShutdownTask;
import software.amazon.kinesis.lifecycle.TaskType;
import software.amazon.kinesis.lifecycle.events.ProcessRecordsInput;
import software.amazon.kinesis.retrieval.ThrottlingReporter;

class ConsumerStates {
    static final ConsumerState INITIAL_STATE = ShardConsumerState.WAITING_ON_PARENT_SHARDS.consumerState();
    static final ConsumerState SHUTDOWN_REQUEST_COMPLETION_STATE = new ShutdownNotificationCompletionState();

    ConsumerStates() {
    }

    private static ConsumerState shutdownStateFor(ShutdownReason reason) {
        switch (reason) {
            case REQUESTED: {
                return ShardConsumerState.SHUTDOWN_REQUESTED.consumerState();
            }
            case SHARD_END: 
            case LEASE_LOST: {
                return ShardConsumerState.SHUTTING_DOWN.consumerState();
            }
        }
        throw new IllegalArgumentException("Unknown reason: " + (Object)((Object)reason));
    }

    static class ShutdownCompleteState
    implements ConsumerState {
        ShutdownCompleteState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument argument, ShardConsumer consumer, ProcessRecordsInput input) {
            if (consumer.shutdownNotification() != null) {
                consumer.shutdownNotification().shutdownComplete();
            }
            return null;
        }

        @Override
        public ConsumerState successTransition() {
            return this;
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return this;
        }

        @Override
        public TaskType taskType() {
            return TaskType.SHUTDOWN_COMPLETE;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.SHUTDOWN_COMPLETE;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    static class ShuttingDownState
    implements ConsumerState {
        ShuttingDownState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument argument, ShardConsumer consumer, ProcessRecordsInput input) {
            return new ShutdownTask(argument.shardInfo(), argument.shardDetector(), argument.shardRecordProcessor(), argument.recordProcessorCheckpointer(), consumer.shutdownReason(), argument.initialPositionInStream(), argument.cleanupLeasesOfCompletedShards(), argument.ignoreUnexpectedChildShards(), argument.leaseRefresher(), argument.taskBackoffTimeMillis(), argument.recordsPublisher(), argument.metricsFactory());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.SHUTDOWN_COMPLETE.consumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return ShardConsumerState.SHUTDOWN_COMPLETE.consumerState();
        }

        @Override
        public TaskType taskType() {
            return TaskType.SHUTDOWN;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.SHUTTING_DOWN;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class ShutdownNotificationCompletionState
    implements ConsumerState {
        ShutdownNotificationCompletionState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument argument, ShardConsumer consumer, ProcessRecordsInput input) {
            return null;
        }

        @Override
        public ConsumerState successTransition() {
            return this;
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            if (shutdownReason != ShutdownReason.REQUESTED) {
                return shutdownReason.shutdownState();
            }
            return this;
        }

        @Override
        public TaskType taskType() {
            return TaskType.SHUTDOWN_NOTIFICATION;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.SHUTDOWN_REQUESTED;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }

        @Override
        public boolean requiresAwake() {
            return true;
        }
    }

    static class ShutdownNotificationState
    implements ConsumerState {
        ShutdownNotificationState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument argument, ShardConsumer consumer, ProcessRecordsInput input) {
            return new ShutdownNotificationTask(argument.shardRecordProcessor(), argument.recordProcessorCheckpointer(), consumer.shutdownNotification(), argument.shardInfo());
        }

        @Override
        public ConsumerState successTransition() {
            return SHUTDOWN_REQUEST_COMPLETION_STATE;
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            if (shutdownReason == ShutdownReason.REQUESTED) {
                return SHUTDOWN_REQUEST_COMPLETION_STATE;
            }
            return shutdownReason.shutdownState();
        }

        @Override
        public TaskType taskType() {
            return TaskType.SHUTDOWN_NOTIFICATION;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.SHUTDOWN_REQUESTED;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class ProcessingState
    implements ConsumerState {
        ProcessingState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument argument, ShardConsumer consumer, ProcessRecordsInput input) {
            ThrottlingReporter throttlingReporter = new ThrottlingReporter(5, argument.shardInfo().shardId());
            return new ProcessTask(argument.shardInfo(), argument.shardRecordProcessor(), argument.recordProcessorCheckpointer(), argument.taskBackoffTimeMillis(), argument.skipShardSyncAtWorkerInitializationIfLeasesExist(), argument.shardDetector(), throttlingReporter, input, argument.shouldCallProcessRecordsEvenForEmptyRecordList(), argument.idleTimeInMilliseconds(), argument.aggregatorUtil(), argument.metricsFactory());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.PROCESSING.consumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return shutdownReason.shutdownState();
        }

        @Override
        public TaskType taskType() {
            return TaskType.PROCESS;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.PROCESSING;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }

        @Override
        public boolean requiresDataAvailability() {
            return true;
        }
    }

    static class InitializingState
    implements ConsumerState {
        InitializingState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument argument, ShardConsumer consumer, ProcessRecordsInput input) {
            return new InitializeTask(argument.shardInfo(), argument.shardRecordProcessor(), argument.checkpoint(), argument.recordProcessorCheckpointer(), argument.initialPositionInStream(), argument.recordsPublisher(), argument.taskBackoffTimeMillis(), argument.metricsFactory());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.PROCESSING.consumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return shutdownReason.shutdownState();
        }

        @Override
        public TaskType taskType() {
            return TaskType.INITIALIZE;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.INITIALIZING;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class BlockedOnParentState
    implements ConsumerState {
        BlockedOnParentState() {
        }

        @Override
        public ConsumerTask createTask(ShardConsumerArgument consumerArgument, ShardConsumer consumer, ProcessRecordsInput input) {
            return new BlockOnParentShardTask(consumerArgument.shardInfo(), consumerArgument.leaseRefresher(), consumerArgument.parentShardPollIntervalMillis());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.INITIALIZING.consumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return ShardConsumerState.SHUTDOWN_COMPLETE.consumerState();
        }

        @Override
        public TaskType taskType() {
            return TaskType.BLOCK_ON_PARENT_SHARDS;
        }

        @Override
        public ShardConsumerState state() {
            return ShardConsumerState.WAITING_ON_PARENT_SHARDS;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static enum ShardConsumerState {
        WAITING_ON_PARENT_SHARDS(new BlockedOnParentState()),
        INITIALIZING(new InitializingState()),
        PROCESSING(new ProcessingState()),
        SHUTDOWN_REQUESTED(new ShutdownNotificationState()),
        SHUTTING_DOWN(new ShuttingDownState()),
        SHUTDOWN_COMPLETE(new ShutdownCompleteState());

        private final ConsumerState consumerState;

        private ShardConsumerState(ConsumerState consumerState) {
            this.consumerState = consumerState;
        }

        public ConsumerState consumerState() {
            return this.consumerState;
        }
    }
}

