/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.leases.dynamodb;

import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.KinesisShardDetector;
import software.amazon.kinesis.leases.LeaseCoordinator;
import software.amazon.kinesis.leases.LeaseManagementFactory;
import software.amazon.kinesis.leases.ShardDetector;
import software.amazon.kinesis.leases.ShardSyncTaskManager;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseCoordinator;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseRefresher;
import software.amazon.kinesis.leases.dynamodb.DynamoDBLeaseSerializer;
import software.amazon.kinesis.metrics.MetricsFactory;

@KinesisClientInternalApi
public class DynamoDBLeaseManagementFactory
implements LeaseManagementFactory {
    @NonNull
    private final KinesisAsyncClient kinesisClient;
    @NonNull
    private final String streamName;
    @NonNull
    private final DynamoDbAsyncClient dynamoDBClient;
    @NonNull
    private final String tableName;
    @NonNull
    private final String workerIdentifier;
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final InitialPositionInStreamExtended initialPositionInStream;
    private final long failoverTimeMillis;
    private final long epsilonMillis;
    private final int maxLeasesForWorker;
    private final int maxLeasesToStealAtOneTime;
    private final int maxLeaseRenewalThreads;
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean ignoreUnexpectedChildShards;
    private final long shardSyncIntervalMillis;
    private final boolean consistentReads;
    private final long listShardsBackoffTimeMillis;
    private final int maxListShardsRetryAttempts;
    private final int maxCacheMissesBeforeReload;
    private final long listShardsCacheAllowedAgeInSeconds;
    private final int cacheMissWarningModulus;
    private final long initialLeaseTableReadCapacity;
    private final long initialLeaseTableWriteCapacity;

    @Deprecated
    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus) {
        this(kinesisClient, streamName, dynamoDBClient, tableName, workerIdentifier, executorService, initialPositionInStream, failoverTimeMillis, epsilonMillis, maxLeasesForWorker, maxLeasesToStealAtOneTime, maxLeaseRenewalThreads, cleanupLeasesUponShardCompletion, ignoreUnexpectedChildShards, shardSyncIntervalMillis, consistentReads, listShardsBackoffTimeMillis, maxListShardsRetryAttempts, maxCacheMissesBeforeReload, listShardsCacheAllowedAgeInSeconds, cacheMissWarningModulus, 10L, 10L);
    }

    public DynamoDBLeaseManagementFactory(KinesisAsyncClient kinesisClient, String streamName, DynamoDbAsyncClient dynamoDBClient, String tableName, String workerIdentifier, ExecutorService executorService, InitialPositionInStreamExtended initialPositionInStream, long failoverTimeMillis, long epsilonMillis, int maxLeasesForWorker, int maxLeasesToStealAtOneTime, int maxLeaseRenewalThreads, boolean cleanupLeasesUponShardCompletion, boolean ignoreUnexpectedChildShards, long shardSyncIntervalMillis, boolean consistentReads, long listShardsBackoffTimeMillis, int maxListShardsRetryAttempts, int maxCacheMissesBeforeReload, long listShardsCacheAllowedAgeInSeconds, int cacheMissWarningModulus, long initialLeaseTableReadCapacity, long initialLeaseTableWriteCapacity) {
        this.kinesisClient = kinesisClient;
        this.streamName = streamName;
        this.dynamoDBClient = dynamoDBClient;
        this.tableName = tableName;
        this.workerIdentifier = workerIdentifier;
        this.executorService = executorService;
        this.initialPositionInStream = initialPositionInStream;
        this.failoverTimeMillis = failoverTimeMillis;
        this.epsilonMillis = epsilonMillis;
        this.maxLeasesForWorker = maxLeasesForWorker;
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        this.consistentReads = consistentReads;
        this.listShardsBackoffTimeMillis = listShardsBackoffTimeMillis;
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        this.maxCacheMissesBeforeReload = maxCacheMissesBeforeReload;
        this.listShardsCacheAllowedAgeInSeconds = listShardsCacheAllowedAgeInSeconds;
        this.cacheMissWarningModulus = cacheMissWarningModulus;
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
    }

    @Override
    public LeaseCoordinator createLeaseCoordinator(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new DynamoDBLeaseCoordinator(this.createLeaseRefresher(), this.workerIdentifier, this.failoverTimeMillis, this.epsilonMillis, this.maxLeasesForWorker, this.maxLeasesToStealAtOneTime, this.maxLeaseRenewalThreads, this.initialLeaseTableReadCapacity, this.initialLeaseTableWriteCapacity, metricsFactory);
    }

    @Override
    public ShardSyncTaskManager createShardSyncTaskManager(@NonNull MetricsFactory metricsFactory) {
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        return new ShardSyncTaskManager(this.createShardDetector(), this.createLeaseRefresher(), this.initialPositionInStream, this.cleanupLeasesUponShardCompletion, this.ignoreUnexpectedChildShards, this.shardSyncIntervalMillis, this.executorService, metricsFactory);
    }

    @Override
    public DynamoDBLeaseRefresher createLeaseRefresher() {
        return new DynamoDBLeaseRefresher(this.tableName, this.dynamoDBClient, new DynamoDBLeaseSerializer(), this.consistentReads);
    }

    @Override
    public ShardDetector createShardDetector() {
        return new KinesisShardDetector(this.kinesisClient, this.streamName, this.listShardsBackoffTimeMillis, this.maxListShardsRetryAttempts, this.listShardsCacheAllowedAgeInSeconds, this.maxCacheMissesBeforeReload, this.cacheMissWarningModulus);
    }

    @NonNull
    public KinesisAsyncClient getKinesisClient() {
        return this.kinesisClient;
    }

    @NonNull
    public String getStreamName() {
        return this.streamName;
    }

    @NonNull
    public DynamoDbAsyncClient getDynamoDBClient() {
        return this.dynamoDBClient;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    @NonNull
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @NonNull
    public InitialPositionInStreamExtended getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public long getEpsilonMillis() {
        return this.epsilonMillis;
    }

    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public int getMaxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    public int getMaxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    public boolean isCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean isIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public boolean isConsistentReads() {
        return this.consistentReads;
    }

    public long getListShardsBackoffTimeMillis() {
        return this.listShardsBackoffTimeMillis;
    }

    public int getMaxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }

    public int getMaxCacheMissesBeforeReload() {
        return this.maxCacheMissesBeforeReload;
    }

    public long getListShardsCacheAllowedAgeInSeconds() {
        return this.listShardsCacheAllowedAgeInSeconds;
    }

    public int getCacheMissWarningModulus() {
        return this.cacheMissWarningModulus;
    }

    public long getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public long getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBLeaseManagementFactory)) {
            return false;
        }
        DynamoDBLeaseManagementFactory other = (DynamoDBLeaseManagementFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KinesisAsyncClient this$kinesisClient = this.getKinesisClient();
        KinesisAsyncClient other$kinesisClient = other.getKinesisClient();
        if (this$kinesisClient == null ? other$kinesisClient != null : !this$kinesisClient.equals(other$kinesisClient)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        DynamoDbAsyncClient this$dynamoDBClient = this.getDynamoDBClient();
        DynamoDbAsyncClient other$dynamoDBClient = other.getDynamoDBClient();
        if (this$dynamoDBClient == null ? other$dynamoDBClient != null : !this$dynamoDBClient.equals(other$dynamoDBClient)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$workerIdentifier = this.getWorkerIdentifier();
        String other$workerIdentifier = other.getWorkerIdentifier();
        if (this$workerIdentifier == null ? other$workerIdentifier != null : !this$workerIdentifier.equals(other$workerIdentifier)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        if (this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService)) {
            return false;
        }
        InitialPositionInStreamExtended this$initialPositionInStream = this.getInitialPositionInStream();
        InitialPositionInStreamExtended other$initialPositionInStream = other.getInitialPositionInStream();
        if (this$initialPositionInStream == null ? other$initialPositionInStream != null : !this$initialPositionInStream.equals(other$initialPositionInStream)) {
            return false;
        }
        if (this.getFailoverTimeMillis() != other.getFailoverTimeMillis()) {
            return false;
        }
        if (this.getEpsilonMillis() != other.getEpsilonMillis()) {
            return false;
        }
        if (this.getMaxLeasesForWorker() != other.getMaxLeasesForWorker()) {
            return false;
        }
        if (this.getMaxLeasesToStealAtOneTime() != other.getMaxLeasesToStealAtOneTime()) {
            return false;
        }
        if (this.getMaxLeaseRenewalThreads() != other.getMaxLeaseRenewalThreads()) {
            return false;
        }
        if (this.isCleanupLeasesUponShardCompletion() != other.isCleanupLeasesUponShardCompletion()) {
            return false;
        }
        if (this.isIgnoreUnexpectedChildShards() != other.isIgnoreUnexpectedChildShards()) {
            return false;
        }
        if (this.getShardSyncIntervalMillis() != other.getShardSyncIntervalMillis()) {
            return false;
        }
        if (this.isConsistentReads() != other.isConsistentReads()) {
            return false;
        }
        if (this.getListShardsBackoffTimeMillis() != other.getListShardsBackoffTimeMillis()) {
            return false;
        }
        if (this.getMaxListShardsRetryAttempts() != other.getMaxListShardsRetryAttempts()) {
            return false;
        }
        if (this.getMaxCacheMissesBeforeReload() != other.getMaxCacheMissesBeforeReload()) {
            return false;
        }
        if (this.getListShardsCacheAllowedAgeInSeconds() != other.getListShardsCacheAllowedAgeInSeconds()) {
            return false;
        }
        if (this.getCacheMissWarningModulus() != other.getCacheMissWarningModulus()) {
            return false;
        }
        if (this.getInitialLeaseTableReadCapacity() != other.getInitialLeaseTableReadCapacity()) {
            return false;
        }
        return this.getInitialLeaseTableWriteCapacity() == other.getInitialLeaseTableWriteCapacity();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBLeaseManagementFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KinesisAsyncClient $kinesisClient = this.getKinesisClient();
        result = result * 59 + ($kinesisClient == null ? 43 : $kinesisClient.hashCode());
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        DynamoDbAsyncClient $dynamoDBClient = this.getDynamoDBClient();
        result = result * 59 + ($dynamoDBClient == null ? 43 : $dynamoDBClient.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $workerIdentifier = this.getWorkerIdentifier();
        result = result * 59 + ($workerIdentifier == null ? 43 : $workerIdentifier.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        InitialPositionInStreamExtended $initialPositionInStream = this.getInitialPositionInStream();
        result = result * 59 + ($initialPositionInStream == null ? 43 : $initialPositionInStream.hashCode());
        long $failoverTimeMillis = this.getFailoverTimeMillis();
        result = result * 59 + (int)($failoverTimeMillis >>> 32 ^ $failoverTimeMillis);
        long $epsilonMillis = this.getEpsilonMillis();
        result = result * 59 + (int)($epsilonMillis >>> 32 ^ $epsilonMillis);
        result = result * 59 + this.getMaxLeasesForWorker();
        result = result * 59 + this.getMaxLeasesToStealAtOneTime();
        result = result * 59 + this.getMaxLeaseRenewalThreads();
        result = result * 59 + (this.isCleanupLeasesUponShardCompletion() ? 79 : 97);
        result = result * 59 + (this.isIgnoreUnexpectedChildShards() ? 79 : 97);
        long $shardSyncIntervalMillis = this.getShardSyncIntervalMillis();
        result = result * 59 + (int)($shardSyncIntervalMillis >>> 32 ^ $shardSyncIntervalMillis);
        result = result * 59 + (this.isConsistentReads() ? 79 : 97);
        long $listShardsBackoffTimeMillis = this.getListShardsBackoffTimeMillis();
        result = result * 59 + (int)($listShardsBackoffTimeMillis >>> 32 ^ $listShardsBackoffTimeMillis);
        result = result * 59 + this.getMaxListShardsRetryAttempts();
        result = result * 59 + this.getMaxCacheMissesBeforeReload();
        long $listShardsCacheAllowedAgeInSeconds = this.getListShardsCacheAllowedAgeInSeconds();
        result = result * 59 + (int)($listShardsCacheAllowedAgeInSeconds >>> 32 ^ $listShardsCacheAllowedAgeInSeconds);
        result = result * 59 + this.getCacheMissWarningModulus();
        long $initialLeaseTableReadCapacity = this.getInitialLeaseTableReadCapacity();
        result = result * 59 + (int)($initialLeaseTableReadCapacity >>> 32 ^ $initialLeaseTableReadCapacity);
        long $initialLeaseTableWriteCapacity = this.getInitialLeaseTableWriteCapacity();
        result = result * 59 + (int)($initialLeaseTableWriteCapacity >>> 32 ^ $initialLeaseTableWriteCapacity);
        return result;
    }

    public String toString() {
        return "DynamoDBLeaseManagementFactory(kinesisClient=" + this.getKinesisClient() + ", streamName=" + this.getStreamName() + ", dynamoDBClient=" + this.getDynamoDBClient() + ", tableName=" + this.getTableName() + ", workerIdentifier=" + this.getWorkerIdentifier() + ", executorService=" + this.getExecutorService() + ", initialPositionInStream=" + this.getInitialPositionInStream() + ", failoverTimeMillis=" + this.getFailoverTimeMillis() + ", epsilonMillis=" + this.getEpsilonMillis() + ", maxLeasesForWorker=" + this.getMaxLeasesForWorker() + ", maxLeasesToStealAtOneTime=" + this.getMaxLeasesToStealAtOneTime() + ", maxLeaseRenewalThreads=" + this.getMaxLeaseRenewalThreads() + ", cleanupLeasesUponShardCompletion=" + this.isCleanupLeasesUponShardCompletion() + ", ignoreUnexpectedChildShards=" + this.isIgnoreUnexpectedChildShards() + ", shardSyncIntervalMillis=" + this.getShardSyncIntervalMillis() + ", consistentReads=" + this.isConsistentReads() + ", listShardsBackoffTimeMillis=" + this.getListShardsBackoffTimeMillis() + ", maxListShardsRetryAttempts=" + this.getMaxListShardsRetryAttempts() + ", maxCacheMissesBeforeReload=" + this.getMaxCacheMissesBeforeReload() + ", listShardsCacheAllowedAgeInSeconds=" + this.getListShardsCacheAllowedAgeInSeconds() + ", cacheMissWarningModulus=" + this.getCacheMissWarningModulus() + ", initialLeaseTableReadCapacity=" + this.getInitialLeaseTableReadCapacity() + ", initialLeaseTableWriteCapacity=" + this.getInitialLeaseTableWriteCapacity() + ")";
    }
}

