/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import software.amazon.kinesis.annotations.KinesisClientInternalApi;
import software.amazon.kinesis.checkpoint.ShardRecordProcessorCheckpointer;
import software.amazon.kinesis.coordinator.CoordinatorFactory;
import software.amazon.kinesis.coordinator.GracefulShutdownCoordinator;
import software.amazon.kinesis.coordinator.NoOpWorkerStateChangeListener;
import software.amazon.kinesis.coordinator.WorkerStateChangeListener;
import software.amazon.kinesis.leases.ShardInfo;
import software.amazon.kinesis.processor.Checkpointer;

@KinesisClientInternalApi
public class SchedulerCoordinatorFactory
implements CoordinatorFactory {
    @Override
    public ExecutorService createExecutorService() {
        return new SchedulerThreadPoolExecutor(new ThreadFactoryBuilder().setNameFormat("ShardRecordProcessor-%04d").build());
    }

    @Override
    public GracefulShutdownCoordinator createGracefulShutdownCoordinator() {
        return new GracefulShutdownCoordinator();
    }

    @Override
    public WorkerStateChangeListener createWorkerStateChangeListener() {
        return new NoOpWorkerStateChangeListener();
    }

    @Override
    public ShardRecordProcessorCheckpointer createRecordProcessorCheckpointer(@NonNull ShardInfo shardInfo, @NonNull Checkpointer checkpoint) {
        if (shardInfo == null) {
            throw new NullPointerException("shardInfo");
        }
        if (checkpoint == null) {
            throw new NullPointerException("checkpoint");
        }
        return new ShardRecordProcessorCheckpointer(shardInfo, checkpoint);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerCoordinatorFactory)) {
            return false;
        }
        SchedulerCoordinatorFactory other = (SchedulerCoordinatorFactory)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulerCoordinatorFactory;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "SchedulerCoordinatorFactory()";
    }

    static class SchedulerThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final long DEFAULT_KEEP_ALIVE = 60L;

        SchedulerThreadPoolExecutor(ThreadFactory threadFactory) {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
    }
}

