/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.common;

import java.util.Date;
import software.amazon.kinesis.common.InitialPositionInStream;

public class InitialPositionInStreamExtended {
    private final InitialPositionInStream position;
    private final Date timestamp;

    private InitialPositionInStreamExtended(InitialPositionInStream position, Date timestamp) {
        this.position = position;
        this.timestamp = timestamp;
    }

    public InitialPositionInStream getInitialPositionInStream() {
        return this.position;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public static InitialPositionInStreamExtended newInitialPosition(InitialPositionInStream position) {
        switch (position) {
            case LATEST: {
                return new InitialPositionInStreamExtended(InitialPositionInStream.LATEST, null);
            }
            case TRIM_HORIZON: {
                return new InitialPositionInStreamExtended(InitialPositionInStream.TRIM_HORIZON, null);
            }
        }
        throw new IllegalArgumentException("Invalid InitialPosition: " + (Object)((Object)position));
    }

    public static InitialPositionInStreamExtended newInitialPositionAtTimestamp(Date timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Timestamp must be specified for InitialPosition AT_TIMESTAMP");
        }
        return new InitialPositionInStreamExtended(InitialPositionInStream.AT_TIMESTAMP, timestamp);
    }
}

