/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.checkpoint;

import software.amazon.kinesis.exceptions.InvalidStateException;
import software.amazon.kinesis.exceptions.KinesisClientLibDependencyException;
import software.amazon.kinesis.exceptions.ShutdownException;
import software.amazon.kinesis.exceptions.ThrottlingException;
import software.amazon.kinesis.processor.PreparedCheckpointer;
import software.amazon.kinesis.processor.RecordProcessorCheckpointer;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class ShardPreparedCheckpointer
implements PreparedCheckpointer {
    private final ExtendedSequenceNumber pendingCheckpointSequenceNumber;
    private final RecordProcessorCheckpointer checkpointer;

    public ShardPreparedCheckpointer(ExtendedSequenceNumber pendingCheckpointSequenceNumber, RecordProcessorCheckpointer checkpointer) {
        this.pendingCheckpointSequenceNumber = pendingCheckpointSequenceNumber;
        this.checkpointer = checkpointer;
    }

    @Override
    public ExtendedSequenceNumber pendingCheckpoint() {
        return this.pendingCheckpointSequenceNumber;
    }

    @Override
    public void checkpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        this.checkpointer.checkpoint(this.pendingCheckpointSequenceNumber.sequenceNumber(), this.pendingCheckpointSequenceNumber.subSequenceNumber());
    }
}

