/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.multilang.MultiLangRecordProcessorFactory;
import software.amazon.kinesis.multilang.config.KinesisClientLibConfigurator;
import software.amazon.kinesis.multilang.config.MultiLangDaemonConfiguration;

public class MultiLangDaemonConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiLangDaemonConfig.class);
    private static final String USER_AGENT = "amazon-kinesis-multi-lang-daemon";
    private static final String VERSION = "1.0.1";
    private static final String PROP_EXECUTABLE_NAME = "executableName";
    private static final String PROP_PROCESSING_LANGUAGE = "processingLanguage";
    private static final String PROP_MAX_ACTIVE_THREADS = "maxActiveThreads";
    private final MultiLangDaemonConfiguration multiLangDaemonConfiguration;
    private final ExecutorService executorService;
    private final MultiLangRecordProcessorFactory recordProcessorFactory;

    public MultiLangDaemonConfig(String propertiesFile) throws IOException, IllegalArgumentException {
        this(propertiesFile, Thread.currentThread().getContextClassLoader());
    }

    public MultiLangDaemonConfig(String propertiesFile, ClassLoader classLoader) throws IOException, IllegalArgumentException {
        this(propertiesFile, classLoader, new KinesisClientLibConfigurator());
    }

    public MultiLangDaemonConfig(String propertiesFile, ClassLoader classLoader, KinesisClientLibConfigurator configurator) throws IOException, IllegalArgumentException {
        Properties properties = MultiLangDaemonConfig.loadProperties(classLoader, propertiesFile);
        if (!MultiLangDaemonConfig.validateProperties(properties)) {
            throw new IllegalArgumentException("Must provide an executable name in the properties file, e.g. executableName = sampleapp.py");
        }
        String executableName = properties.getProperty(PROP_EXECUTABLE_NAME);
        String processingLanguage = properties.getProperty(PROP_PROCESSING_LANGUAGE);
        this.multiLangDaemonConfiguration = configurator.getConfiguration(properties);
        this.executorService = MultiLangDaemonConfig.buildExecutorService(properties);
        this.recordProcessorFactory = new MultiLangRecordProcessorFactory(executableName, this.executorService, this.multiLangDaemonConfiguration);
        log.info("Running {} to process stream {} with executable {}", new Object[]{this.multiLangDaemonConfiguration.getApplicationName(), this.multiLangDaemonConfiguration.getStreamName(), executableName});
        this.prepare(processingLanguage);
    }

    private void prepare(String processingLanguage) {
        Security.setProperty("networkaddress.cache.ttl", "60");
        log.info("Using workerId: {}", (Object)this.multiLangDaemonConfiguration.getWorkerIdentifier());
        StringBuilder userAgent = new StringBuilder("amazon-kinesis-client-library-java");
        userAgent.append(" ");
        userAgent.append(USER_AGENT);
        userAgent.append("/");
        userAgent.append(VERSION);
        if (processingLanguage != null) {
            userAgent.append(" ");
            userAgent.append(processingLanguage);
        }
        if (this.recordProcessorFactory.getCommandArray().length > 0) {
            userAgent.append(" ");
            userAgent.append(this.recordProcessorFactory.getCommandArray()[0]);
        }
        log.info("MultiLangDaemon is adding the following fields to the User Agent: {}", (Object)userAgent.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(ClassLoader classLoader, String propertiesFileName) throws IOException {
        Properties properties = new Properties();
        try (InputStream propertyStream = null;){
            File propertyFile;
            propertyStream = classLoader.getResourceAsStream(propertiesFileName);
            if (propertyStream == null && (propertyFile = new File(propertiesFileName)).exists()) {
                propertyStream = new FileInputStream(propertyFile);
            }
            if (propertyStream == null) {
                throw new FileNotFoundException("Unable to find property file in classpath, or file system: '" + propertiesFileName + "'");
            }
            properties.load(propertyStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private static boolean validateProperties(Properties properties) {
        return properties != null && properties.getProperty(PROP_EXECUTABLE_NAME) != null;
    }

    private static int getMaxActiveThreads(Properties properties) {
        return Integer.parseInt(properties.getProperty(PROP_MAX_ACTIVE_THREADS, "0"));
    }

    private static ExecutorService buildExecutorService(Properties properties) {
        int maxActiveThreads = MultiLangDaemonConfig.getMaxActiveThreads(properties);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setNameFormat("multi-lang-daemon-%04d");
        log.debug("Value for {} property is {}", (Object)PROP_MAX_ACTIVE_THREADS, (Object)maxActiveThreads);
        if (maxActiveThreads <= 0) {
            log.info("Using a cached thread pool.");
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), builder.build());
        }
        log.info("Using a fixed thread pool with {} max active threads.", (Object)maxActiveThreads);
        return new ThreadPoolExecutor(maxActiveThreads, maxActiveThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), builder.build());
    }

    public MultiLangDaemonConfiguration getMultiLangDaemonConfiguration() {
        return this.multiLangDaemonConfiguration;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public MultiLangRecordProcessorFactory getRecordProcessorFactory() {
        return this.recordProcessorFactory;
    }
}

