/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.messages;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import software.amazon.kinesis.lifecycle.events.ProcessRecordsInput;
import software.amazon.kinesis.multilang.messages.JsonFriendlyRecord;
import software.amazon.kinesis.multilang.messages.Message;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class ProcessRecordsMessage
extends Message {
    public static final String ACTION = "processRecords";
    private List<JsonFriendlyRecord> records;
    private Long millisBehindLatest;

    public ProcessRecordsMessage() {
    }

    public ProcessRecordsMessage(ProcessRecordsInput processRecordsInput) {
        this.millisBehindLatest = processRecordsInput.millisBehindLatest();
        ArrayList<JsonFriendlyRecord> recordMessages = new ArrayList<JsonFriendlyRecord>();
        for (KinesisClientRecord record : processRecordsInput.records()) {
            recordMessages.add(JsonFriendlyRecord.fromKinesisClientRecord(record));
        }
        this.setRecords(recordMessages);
    }

    @Generated
    public List<JsonFriendlyRecord> getRecords() {
        return this.records;
    }

    @Generated
    public Long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }

    @Generated
    public void setRecords(List<JsonFriendlyRecord> records) {
        this.records = records;
    }

    @Generated
    public void setMillisBehindLatest(Long millisBehindLatest) {
        this.millisBehindLatest = millisBehindLatest;
    }
}

