/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import software.amazon.kinesis.multilang.config.DynaBeanBuilderSupport;
import software.amazon.kinesis.multilang.config.DynaBeanBuilderUtils;
import software.amazon.kinesis.multilang.config.DynaBeanCreateSupport;
import software.amazon.kinesis.multilang.config.TypeTag;

public class BuilderDynaBean
implements DynaBean {
    private static final String[] CLASS_NAME_JOINERS = new String[]{ClassUtils.PACKAGE_SEPARATOR, ClassUtils.INNER_CLASS_SEPARATOR};
    static final String NO_MAP_ACCESS_SUPPORT = "Map access isn't supported";
    private Class<?> destinedClass;
    private final ConvertUtilsBean convertUtilsBean;
    private final List<String> classPrefixSearchList;
    private DynaBeanCreateSupport dynaBeanCreateSupport;
    private DynaBeanBuilderSupport dynaBeanBuilderSupport;
    private boolean isDirty = false;
    private final Function<String, ?> emptyPropertyHandler;
    private Object emptyPropertyResolved = null;

    public BuilderDynaBean(Class<?> destinedClass, ConvertUtilsBean convertUtilsBean, String ... classPrefixSearchList) {
        this(destinedClass, convertUtilsBean, null, Arrays.asList(classPrefixSearchList));
    }

    public BuilderDynaBean(Class<?> destinedClass, ConvertUtilsBean convertUtilsBean, Function<String, ?> emptyPropertyHandler, String ... classPrefixSearchList) {
        this(destinedClass, convertUtilsBean, emptyPropertyHandler, Arrays.asList(classPrefixSearchList));
    }

    public BuilderDynaBean(Class<?> destinedClass, ConvertUtilsBean convertUtilsBean, Function<String, ?> emptyPropertyHandler, List<String> classPrefixSearchList) {
        this.convertUtilsBean = convertUtilsBean;
        this.classPrefixSearchList = classPrefixSearchList;
        this.emptyPropertyHandler = emptyPropertyHandler;
        this.initialize(destinedClass);
    }

    private void initialize(Class<?> destinedClass) {
        this.destinedClass = destinedClass;
        if (DynaBeanBuilderUtils.isBuilderOrCreate(destinedClass)) {
            this.dynaBeanBuilderSupport = new DynaBeanBuilderSupport(destinedClass, this.convertUtilsBean, this.classPrefixSearchList);
            this.dynaBeanCreateSupport = new DynaBeanCreateSupport(destinedClass, this.convertUtilsBean, this.classPrefixSearchList);
        }
    }

    private void reinitializeFrom(String newClass) {
        Class<?> newClazz = null;
        ArrayList<String> attempts = new ArrayList<String>();
        attempts.add(newClass);
        try {
            newClazz = Class.forName(newClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (newClazz == null) {
            block4: for (String prefix : this.classPrefixSearchList) {
                for (String joiner : CLASS_NAME_JOINERS) {
                    String possibleClass = prefix.endsWith(joiner) ? prefix + newClass : prefix + joiner + newClass;
                    attempts.add(possibleClass);
                    try {
                        newClazz = Class.forName(possibleClass);
                        continue block4;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
        }
        if (newClazz == null) {
            throw new IllegalArgumentException("Unable to load class " + newClass + ". Attempted: (" + String.join((CharSequence)", ", attempts) + ")");
        }
        this.initialize(newClazz);
    }

    private void validatedExpectedClass(Class<?> source, Class<?> expected) {
        if (!ClassUtils.isAssignable(source, expected)) {
            throw new IllegalArgumentException(String.format("%s cannot be assigned to %s.", source.getName(), expected.getName()));
        }
    }

    public boolean canBuildOrCreate() {
        return this.dynaBeanBuilderSupport != null || this.dynaBeanCreateSupport != null;
    }

    private void validateCanBuildOrCreate() {
        if (!this.canBuildOrCreate()) {
            throw new IllegalStateException("Unable to to introspect or handle " + this.destinedClass.getName() + " as it doesn't have a builder or create method.");
        }
    }

    @SafeVarargs
    public final <T> T build(Class<T> expected, Function<Object, Object> ... additionalMutators) {
        if (this.emptyPropertyResolved != null) {
            this.validatedExpectedClass(this.emptyPropertyResolved.getClass(), expected);
            return expected.cast(this.emptyPropertyResolved);
        }
        if (this.dynaBeanBuilderSupport == null && this.dynaBeanCreateSupport == null) {
            return null;
        }
        this.validatedExpectedClass(this.destinedClass, expected);
        if (this.dynaBeanBuilderSupport.isValid()) {
            return expected.cast(this.dynaBeanBuilderSupport.build(additionalMutators));
        }
        return expected.cast(this.dynaBeanCreateSupport.build());
    }

    private void validateResolvedEmptyHandler() {
        if (this.emptyPropertyResolved != null) {
            throw new IllegalStateException("When a property handler is resolved further properties may not be set.");
        }
    }

    boolean hasValue(String name) {
        if (this.dynaBeanBuilderSupport != null) {
            return this.dynaBeanBuilderSupport.hasValue(name);
        }
        return false;
    }

    public boolean contains(String name, String key) {
        throw new UnsupportedOperationException(NO_MAP_ACCESS_SUPPORT);
    }

    public Object get(String name) {
        this.validateResolvedEmptyHandler();
        this.isDirty = true;
        return this.dynaBeanBuilderSupport.get(name);
    }

    public Object get(String name, int index) {
        this.validateResolvedEmptyHandler();
        this.isDirty = true;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return this.dynaBeanCreateSupport.get(name, index);
        }
        return this.dynaBeanBuilderSupport.get(name, index);
    }

    public Object get(String name, String key) {
        throw new UnsupportedOperationException(NO_MAP_ACCESS_SUPPORT);
    }

    public DynaClass getDynaClass() {
        return new DynaClass(){

            public String getName() {
                return BuilderDynaBean.this.destinedClass.getName();
            }

            public DynaProperty getDynaProperty(String name) {
                if (StringUtils.isEmpty((CharSequence)name)) {
                    return new DynaProperty(name);
                }
                if ("class".equals(name)) {
                    return new DynaProperty(name, String.class);
                }
                BuilderDynaBean.this.validateCanBuildOrCreate();
                List<TypeTag> types = BuilderDynaBean.this.dynaBeanBuilderSupport.getProperty(name);
                if (types.size() > 1) {
                    Optional<TypeTag> arrayType = types.stream().filter(t -> t.type.isArray()).findFirst();
                    return arrayType.map(t -> new DynaProperty(name, t.type, t.type.getComponentType())).orElseGet(() -> new DynaProperty(name));
                }
                TypeTag type = types.get(0);
                if (type.hasConverter) {
                    return new DynaProperty(name, type.type);
                }
                if (type.type.isEnum()) {
                    return new DynaProperty(name, String.class);
                }
                return new DynaProperty(name, BuilderDynaBean.class);
            }

            public DynaProperty[] getDynaProperties() {
                BuilderDynaBean.this.validateCanBuildOrCreate();
                return (DynaProperty[])BuilderDynaBean.this.dynaBeanBuilderSupport.getPropertyNames().stream().map(this::getDynaProperty).toArray(DynaProperty[]::new);
            }

            public DynaBean newInstance() {
                return null;
            }
        };
    }

    public void remove(String name, String key) {
        throw new UnsupportedOperationException(NO_MAP_ACCESS_SUPPORT);
    }

    public void set(String name, Object value) {
        this.validateResolvedEmptyHandler();
        this.isDirty = true;
        if (this.emptyPropertyHandler != null && StringUtils.isEmpty((CharSequence)name) && value instanceof String) {
            this.emptyPropertyResolved = this.emptyPropertyHandler.apply((String)value);
            return;
        }
        if ("class".equals(name)) {
            this.reinitializeFrom(value.toString());
        } else {
            this.validateResolvedEmptyHandler();
            this.dynaBeanBuilderSupport.set(name, value);
        }
    }

    public void set(String name, int index, Object value) {
        this.validateResolvedEmptyHandler();
        this.validateCanBuildOrCreate();
        this.isDirty = true;
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.dynaBeanCreateSupport.set(name, index, value);
        } else {
            this.dynaBeanBuilderSupport.set(name, index, value);
        }
    }

    public void set(String name, String key, Object value) {
        throw new UnsupportedOperationException(NO_MAP_ACCESS_SUPPORT);
    }

    public boolean isDirty() {
        return this.isDirty;
    }
}

