/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.kinesis.multilang.NestedPropertyProcessor;

public enum NestedPropertyKey {
    ENDPOINT{

        @Override
        void visit(NestedPropertyProcessor processor, String endpoint) {
            String[] tokens = endpoint.split("\\^");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid " + this.name() + ": " + endpoint);
            }
            processor.acceptEndpoint(tokens[0], tokens[1]);
        }
    }
    ,
    ENDPOINT_REGION{

        @Override
        void visit(NestedPropertyProcessor processor, String regionName) {
            Region region;
            List validRegions = Region.regions();
            if (!validRegions.contains(region = Region.of((String)regionName))) {
                throw new IllegalArgumentException("Invalid region name: " + regionName);
            }
            processor.acceptEndpointRegion(region);
        }
    }
    ,
    EXTERNAL_ID{

        @Override
        void visit(NestedPropertyProcessor processor, String externalId) {
            processor.acceptExternalId(externalId);
        }
    };

    private static final Logger log;
    private final String nestedKey = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());

    abstract void visit(NestedPropertyProcessor var1, String var2);

    public static void parse(NestedPropertyProcessor processor, String ... params) {
        HashMap<String, NestedPropertyKey> cachedKeys = new HashMap<String, NestedPropertyKey>();
        for (NestedPropertyKey nestedPropertyKey : NestedPropertyKey.values()) {
            cachedKeys.put(nestedPropertyKey.getNestedKey(), nestedPropertyKey);
        }
        for (String string : params) {
            if (string == null) continue;
            String[] tokens = string.split("=");
            if (tokens.length == 2) {
                NestedPropertyKey npk = (NestedPropertyKey)((Object)cachedKeys.get(tokens[0]));
                if (npk != null) {
                    npk.visit(processor, tokens[1]);
                    continue;
                }
                log.warn("Unsupported nested key: {}", (Object)string);
                continue;
            }
            if (tokens.length > 2) {
                log.warn("Malformed nested key: {}", (Object)string);
                continue;
            }
            log.info("Parameter is not a nested key: {}", (Object)string);
        }
    }

    String getNestedKey() {
        return this.nestedKey;
    }

    static {
        log = LoggerFactory.getLogger(NestedPropertyKey.class);
    }
}

