/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.multilang.MultiLangShardRecordProcessor;
import software.amazon.kinesis.multilang.config.MultiLangDaemonConfiguration;
import software.amazon.kinesis.processor.ShardRecordProcessor;
import software.amazon.kinesis.processor.ShardRecordProcessorFactory;

public class MultiLangRecordProcessorFactory
implements ShardRecordProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(MultiLangRecordProcessorFactory.class);
    private static final String COMMAND_DELIMETER_REGEX = " +";
    private final String command;
    private final String[] commandArray;
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService;
    private final MultiLangDaemonConfiguration configuration;

    public MultiLangRecordProcessorFactory(String command, ExecutorService executorService, MultiLangDaemonConfiguration configuration) {
        this(command, executorService, new ObjectMapper(), configuration);
    }

    public MultiLangRecordProcessorFactory(String command, ExecutorService executorService, ObjectMapper objectMapper, MultiLangDaemonConfiguration configuration) {
        this.command = command;
        this.commandArray = command.split(COMMAND_DELIMETER_REGEX);
        this.executorService = executorService;
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    public ShardRecordProcessor shardRecordProcessor() {
        log.debug("Creating new record processor for client executable: {}", (Object)this.command);
        return new MultiLangShardRecordProcessor(new ProcessBuilder(this.commandArray), this.executorService, this.objectMapper, this.configuration);
    }

    String[] getCommandArray() {
        return this.commandArray;
    }
}

