/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.multilang;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.kinesis.multilang.LineReaderTask;
import software.amazon.kinesis.multilang.messages.Message;

class GetNextMessageTask
extends LineReaderTask<Message> {
    private static final Logger log = LoggerFactory.getLogger(GetNextMessageTask.class);
    private ObjectMapper objectMapper;
    private static final String EMPTY_LINE = "";

    GetNextMessageTask(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static boolean isEmptyLine(String line) {
        return EMPTY_LINE.equals(line);
    }

    @Override
    protected LineReaderTask.HandleLineResult<Message> handleLine(String line) {
        try {
            if (!GetNextMessageTask.isEmptyLine(line)) {
                return new LineReaderTask.HandleLineResult<Object>(this.objectMapper.readValue(line, Message.class));
            }
        }
        catch (IOException e) {
            log.info("Skipping unexpected line on STDOUT for shard {}: {}", (Object)this.getShardId(), (Object)line);
        }
        return new LineReaderTask.HandleLineResult<Message>();
    }

    @Override
    protected Message returnAfterException(Exception e) {
        throw new RuntimeException("Encountered an error while reading a line from STDIN for shard " + this.getShardId() + " so won't be able to return a message.", e);
    }

    @Override
    protected Message returnAfterEndOfInput() {
        throw new RuntimeException("Reached end of STDIN of child process for shard " + this.getShardId() + " so won't be able to return a message.");
    }

    public LineReaderTask<Message> initialize(BufferedReader reader, String shardId) {
        return this.initialize(reader, shardId, "Reading next message from STDIN for " + shardId);
    }
}

