/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.kinesis.coordinator;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.leases.NoOpShardPrioritization;
import software.amazon.kinesis.leases.ShardPrioritization;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.retrieval.DataFetchingStrategy;
import software.amazon.kinesis.retrieval.RecordsFetcherFactory;
import software.amazon.kinesis.retrieval.polling.SimpleRecordsFetcherFactory;

public class KinesisClientLibConfiguration {
    private static final long EPSILON_MS = 25L;
    public static final InitialPositionInStream DEFAULT_INITIAL_POSITION_IN_STREAM = InitialPositionInStream.LATEST;
    public static final long DEFAULT_FAILOVER_TIME_MILLIS = 10000L;
    public static final int DEFAULT_MAX_RECORDS = 10000;
    public static final long DEFAULT_IDLETIME_BETWEEN_READS_MILLIS = 1000L;
    public static final boolean DEFAULT_DONT_CALL_PROCESS_RECORDS_FOR_EMPTY_RECORD_LIST = false;
    public static final long DEFAULT_PARENT_SHARD_POLL_INTERVAL_MILLIS = 10000L;
    public static final long DEFAULT_SHARD_SYNC_INTERVAL_MILLIS = 60000L;
    public static final boolean DEFAULT_CLEANUP_LEASES_UPON_SHARDS_COMPLETION = true;
    public static final long DEFAULT_TASK_BACKOFF_TIME_MILLIS = 500L;
    public static final long DEFAULT_METRICS_BUFFER_TIME_MILLIS = 10000L;
    public static final int DEFAULT_METRICS_MAX_QUEUE_SIZE = 10000;
    public static final MetricsLevel DEFAULT_METRICS_LEVEL = MetricsLevel.DETAILED;
    public static final Set<String> METRICS_ALWAYS_ENABLED_DIMENSIONS = ImmutableSet.of((Object)"Operation");
    public static final Set<String> DEFAULT_METRICS_ENABLED_DIMENSIONS = ImmutableSet.builder().addAll(METRICS_ALWAYS_ENABLED_DIMENSIONS).add((Object)"ShardId").build();
    public static final Set<String> METRICS_DIMENSIONS_ALL = ImmutableSet.of((Object)"ALL");
    public static final String KINESIS_CLIENT_LIB_USER_AGENT = "amazon-kinesis-client-library-java-1.9.0";
    public static final boolean DEFAULT_VALIDATE_SEQUENCE_NUMBER_BEFORE_CHECKPOINTING = true;
    public static final int DEFAULT_MAX_LEASES_FOR_WORKER = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_LEASES_TO_STEAL_AT_ONE_TIME = 1;
    public static final int DEFAULT_INITIAL_LEASE_TABLE_READ_CAPACITY = 10;
    public static final int DEFAULT_INITIAL_LEASE_TABLE_WRITE_CAPACITY = 10;
    public static final boolean DEFAULT_SKIP_SHARD_SYNC_AT_STARTUP_IF_LEASES_EXIST = false;
    public static final ShardPrioritization DEFAULT_SHARD_PRIORITIZATION = new NoOpShardPrioritization();
    public static final long DEFAULT_SHUTDOWN_GRACE_MILLIS = 5000L;
    public static final int DEFAULT_MAX_LEASE_RENEWAL_THREADS = 20;
    public static final long DEFAULT_LIST_SHARDS_BACKOFF_TIME_IN_MILLIS = 1500L;
    public static final int DEFAULT_MAX_LIST_SHARDS_RETRY_ATTEMPTS = 50;
    public static final long DEFAULT_SCHEDULER_INITIALIZATION_BACKOFF_TIME_MILLIS = 1000L;
    private String applicationName;
    private String tableName;
    private String streamName;
    private String kinesisEndpoint;
    private String dynamoDBEndpoint;
    private InitialPositionInStream initialPositionInStream;
    private AwsCredentialsProvider kinesisCredentialsProvider;
    private AwsCredentialsProvider dynamoDBCredentialsProvider;
    private AwsCredentialsProvider cloudWatchCredentialsProvider;
    private long failoverTimeMillis;
    private boolean enablePriorityLeaseAssignment;
    private boolean leaseTableDeletionProtectionEnabled;
    private boolean leaseTablePitrEnabled;
    private String workerIdentifier;
    private long shardSyncIntervalMillis;
    private int maxRecords;
    private long idleTimeBetweenReadsInMillis;
    private boolean callProcessRecordsEvenForEmptyRecordList;
    private long parentShardPollIntervalMillis;
    private boolean cleanupLeasesUponShardCompletion;
    private boolean ignoreUnexpectedChildShards;
    private long taskBackoffTimeMillis;
    private long metricsBufferTimeMillis;
    private int metricsMaxQueueSize;
    private MetricsLevel metricsLevel;
    private Set<String> metricsEnabledDimensions;
    private boolean validateSequenceNumberBeforeCheckpointing;
    private String regionName;
    private int maxLeasesForWorker;
    private int maxLeasesToStealAtOneTime;
    private int initialLeaseTableReadCapacity;
    private int initialLeaseTableWriteCapacity;
    private InitialPositionInStreamExtended initialPositionInStreamExtended;
    private boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    private ShardPrioritization shardPrioritization;
    private long shutdownGraceMillis;
    private Optional<Integer> timeoutInSeconds = Optional.empty();
    private Optional<Integer> retryGetRecordsInSeconds = Optional.empty();
    private Optional<Integer> maxGetRecordsThreadPool = Optional.empty();
    private int maxLeaseRenewalThreads = 20;
    private RecordsFetcherFactory recordsFetcherFactory;
    private Optional<Long> logWarningForTaskAfterMillis = Optional.empty();
    private long listShardsBackoffTimeInMillis = 1500L;
    private int maxListShardsRetryAttempts = 50;
    private long schedulerInitializationBackoffTimeMillis = 1000L;

    public KinesisClientLibConfiguration(String applicationName, String streamName, AwsCredentialsProvider credentialsProvider, String workerId) {
        this(applicationName, streamName, credentialsProvider, credentialsProvider, credentialsProvider, workerId);
    }

    public KinesisClientLibConfiguration(String applicationName, String streamName, AwsCredentialsProvider kinesisCredentialsProvider, AwsCredentialsProvider dynamoDBCredentialsProvider, AwsCredentialsProvider cloudWatchCredentialsProvider, String workerId) {
        this(applicationName, streamName, null, null, DEFAULT_INITIAL_POSITION_IN_STREAM, kinesisCredentialsProvider, dynamoDBCredentialsProvider, cloudWatchCredentialsProvider, 10000L, workerId, 10000, 1000L, false, 10000L, 60000L, true, 500L, 10000L, 10000, true, null, 5000L, 1000L);
    }

    public KinesisClientLibConfiguration(String applicationName, String streamName, String kinesisEndpoint, InitialPositionInStream initialPositionInStream, AwsCredentialsProvider kinesisCredentialsProvider, AwsCredentialsProvider dynamoDBCredentialsProvider, AwsCredentialsProvider cloudWatchCredentialsProvider, long failoverTimeMillis, String workerId, int maxRecords, long idleTimeBetweenReadsInMillis, boolean callProcessRecordsEvenForEmptyRecordList, long parentShardPollIntervalMillis, long shardSyncIntervalMillis, boolean cleanupTerminatedShardsBeforeExpiry, long taskBackoffTimeMillis, long metricsBufferTimeMillis, int metricsMaxQueueSize, boolean validateSequenceNumberBeforeCheckpointing, String regionName, long shutdownGraceMillis, long schedulerInitializationBackoffTimeMillis) {
        this(applicationName, streamName, kinesisEndpoint, null, initialPositionInStream, kinesisCredentialsProvider, dynamoDBCredentialsProvider, cloudWatchCredentialsProvider, failoverTimeMillis, workerId, maxRecords, idleTimeBetweenReadsInMillis, callProcessRecordsEvenForEmptyRecordList, parentShardPollIntervalMillis, shardSyncIntervalMillis, cleanupTerminatedShardsBeforeExpiry, taskBackoffTimeMillis, metricsBufferTimeMillis, metricsMaxQueueSize, validateSequenceNumberBeforeCheckpointing, regionName, shutdownGraceMillis, schedulerInitializationBackoffTimeMillis);
    }

    public KinesisClientLibConfiguration(String applicationName, String streamName, String kinesisEndpoint, String dynamoDBEndpoint, InitialPositionInStream initialPositionInStream, AwsCredentialsProvider kinesisCredentialsProvider, AwsCredentialsProvider dynamoDBCredentialsProvider, AwsCredentialsProvider cloudWatchCredentialsProvider, long failoverTimeMillis, String workerId, int maxRecords, long idleTimeBetweenReadsInMillis, boolean callProcessRecordsEvenForEmptyRecordList, long parentShardPollIntervalMillis, long shardSyncIntervalMillis, boolean cleanupTerminatedShardsBeforeExpiry, long taskBackoffTimeMillis, long metricsBufferTimeMillis, int metricsMaxQueueSize, boolean validateSequenceNumberBeforeCheckpointing, String regionName, long shutdownGraceMillis, long schedulerInitializationBackoffTimeMillis) {
        this.checkIsValuePositive("FailoverTimeMillis", failoverTimeMillis);
        this.checkIsValuePositive("IdleTimeBetweenReadsInMillis", idleTimeBetweenReadsInMillis);
        this.checkIsValuePositive("ParentShardPollIntervalMillis", parentShardPollIntervalMillis);
        this.checkIsValuePositive("ShardSyncIntervalMillis", shardSyncIntervalMillis);
        this.checkIsValuePositive("MaxRecords", maxRecords);
        this.checkIsValuePositive("TaskBackoffTimeMillis", taskBackoffTimeMillis);
        this.checkIsValuePositive("MetricsBufferTimeMills", metricsBufferTimeMillis);
        this.checkIsValuePositive("MetricsMaxQueueSize", metricsMaxQueueSize);
        this.checkIsValuePositive("ShutdownGraceMillis", shutdownGraceMillis);
        this.checkIsValuePositive("schedulerInitializationBackoffTimeMillis", schedulerInitializationBackoffTimeMillis);
        this.checkIsRegionNameValid(regionName);
        this.applicationName = applicationName;
        this.tableName = applicationName;
        this.streamName = streamName;
        this.kinesisEndpoint = kinesisEndpoint;
        this.dynamoDBEndpoint = dynamoDBEndpoint;
        this.initialPositionInStream = initialPositionInStream;
        this.failoverTimeMillis = failoverTimeMillis;
        this.maxRecords = maxRecords;
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        this.cleanupLeasesUponShardCompletion = cleanupTerminatedShardsBeforeExpiry;
        this.workerIdentifier = workerId;
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
        this.metricsMaxQueueSize = metricsMaxQueueSize;
        this.metricsLevel = DEFAULT_METRICS_LEVEL;
        this.metricsEnabledDimensions = DEFAULT_METRICS_ENABLED_DIMENSIONS;
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
        this.regionName = regionName;
        this.maxLeasesForWorker = Integer.MAX_VALUE;
        this.maxLeasesToStealAtOneTime = 1;
        this.initialLeaseTableReadCapacity = 10;
        this.initialLeaseTableWriteCapacity = 10;
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)initialPositionInStream);
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = false;
        this.shardPrioritization = DEFAULT_SHARD_PRIORITIZATION;
        this.recordsFetcherFactory = new SimpleRecordsFetcherFactory();
        this.schedulerInitializationBackoffTimeMillis = schedulerInitializationBackoffTimeMillis;
    }

    public KinesisClientLibConfiguration(String applicationName, String streamName, String kinesisEndpoint, String dynamoDBEndpoint, InitialPositionInStream initialPositionInStream, AwsCredentialsProvider kinesisCredentialsProvider, AwsCredentialsProvider dynamoDBCredentialsProvider, AwsCredentialsProvider cloudWatchCredentialsProvider, long failoverTimeMillis, String workerId, int maxRecords, long idleTimeBetweenReadsInMillis, boolean callProcessRecordsEvenForEmptyRecordList, long parentShardPollIntervalMillis, long shardSyncIntervalMillis, boolean cleanupTerminatedShardsBeforeExpiry, long taskBackoffTimeMillis, long metricsBufferTimeMillis, int metricsMaxQueueSize, boolean validateSequenceNumberBeforeCheckpointing, String regionName, RecordsFetcherFactory recordsFetcherFactory, long schedulerInitializationBackoffTimeMillis) {
        this.checkIsValuePositive("FailoverTimeMillis", failoverTimeMillis);
        this.checkIsValuePositive("IdleTimeBetweenReadsInMillis", idleTimeBetweenReadsInMillis);
        this.checkIsValuePositive("ParentShardPollIntervalMillis", parentShardPollIntervalMillis);
        this.checkIsValuePositive("ShardSyncIntervalMillis", shardSyncIntervalMillis);
        this.checkIsValuePositive("MaxRecords", maxRecords);
        this.checkIsValuePositive("TaskBackoffTimeMillis", taskBackoffTimeMillis);
        this.checkIsValuePositive("MetricsBufferTimeMills", metricsBufferTimeMillis);
        this.checkIsValuePositive("MetricsMaxQueueSize", metricsMaxQueueSize);
        this.checkIsValuePositive("schedulerInitializationBackoffTimeMillis", schedulerInitializationBackoffTimeMillis);
        this.checkIsRegionNameValid(regionName);
        this.applicationName = applicationName;
        this.tableName = applicationName;
        this.streamName = streamName;
        this.kinesisEndpoint = kinesisEndpoint;
        this.dynamoDBEndpoint = dynamoDBEndpoint;
        this.initialPositionInStream = initialPositionInStream;
        this.kinesisCredentialsProvider = kinesisCredentialsProvider;
        this.dynamoDBCredentialsProvider = dynamoDBCredentialsProvider;
        this.cloudWatchCredentialsProvider = cloudWatchCredentialsProvider;
        this.failoverTimeMillis = failoverTimeMillis;
        this.maxRecords = maxRecords;
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        this.cleanupLeasesUponShardCompletion = cleanupTerminatedShardsBeforeExpiry;
        this.workerIdentifier = workerId;
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
        this.metricsMaxQueueSize = metricsMaxQueueSize;
        this.metricsLevel = DEFAULT_METRICS_LEVEL;
        this.metricsEnabledDimensions = DEFAULT_METRICS_ENABLED_DIMENSIONS;
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
        this.regionName = regionName;
        this.maxLeasesForWorker = Integer.MAX_VALUE;
        this.maxLeasesToStealAtOneTime = 1;
        this.initialLeaseTableReadCapacity = 10;
        this.initialLeaseTableWriteCapacity = 10;
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)initialPositionInStream);
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = false;
        this.shardPrioritization = DEFAULT_SHARD_PRIORITIZATION;
        this.recordsFetcherFactory = recordsFetcherFactory;
        this.shutdownGraceMillis = this.shutdownGraceMillis;
        this.schedulerInitializationBackoffTimeMillis = schedulerInitializationBackoffTimeMillis;
    }

    private void checkIsValuePositive(String key, long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("Value of " + key + " should be positive, but current value is " + value);
        }
    }

    private void checkIsRegionNameValid(String regionNameToCheck) {
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public AwsCredentialsProvider getKinesisCredentialsProvider() {
        return this.kinesisCredentialsProvider;
    }

    public AwsCredentialsProvider getDynamoDBCredentialsProvider() {
        return this.dynamoDBCredentialsProvider;
    }

    public AwsCredentialsProvider getCloudWatchCredentialsProvider() {
        return this.cloudWatchCredentialsProvider;
    }

    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public long getIdleTimeBetweenReadsInMillis() {
        return this.idleTimeBetweenReadsInMillis;
    }

    public boolean shouldCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    public long getEpsilonMillis() {
        return 25L;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getKinesisEndpoint() {
        return this.kinesisEndpoint;
    }

    public String getDynamoDBEndpoint() {
        return this.dynamoDBEndpoint;
    }

    public InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    public long getParentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    public long getTaskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    public long getMetricsBufferTimeMillis() {
        return this.metricsBufferTimeMillis;
    }

    public int getMetricsMaxQueueSize() {
        return this.metricsMaxQueueSize;
    }

    public MetricsLevel getMetricsLevel() {
        return this.metricsLevel;
    }

    public Set<String> getMetricsEnabledDimensions() {
        return this.metricsEnabledDimensions;
    }

    public boolean shouldCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean shouldIgnoreUnexpectedChildShards() {
        return this.ignoreUnexpectedChildShards;
    }

    public boolean shouldValidateSequenceNumberBeforeCheckpointing() {
        return this.validateSequenceNumberBeforeCheckpointing;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public boolean getSkipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    public int getMaxLeasesForWorker() {
        return this.maxLeasesForWorker;
    }

    public int getMaxLeasesToStealAtOneTime() {
        return this.maxLeasesToStealAtOneTime;
    }

    public int getInitialLeaseTableReadCapacity() {
        return this.initialLeaseTableReadCapacity;
    }

    public int getInitialLeaseTableWriteCapacity() {
        return this.initialLeaseTableWriteCapacity;
    }

    protected InitialPositionInStreamExtended getInitialPositionInStreamExtended() {
        return this.initialPositionInStreamExtended;
    }

    public Date getTimestampAtInitialPositionInStream() {
        return this.initialPositionInStreamExtended.getTimestamp();
    }

    public ShardPrioritization getShardPrioritizationStrategy() {
        return this.shardPrioritization;
    }

    public long getShutdownGraceMillis() {
        return this.shutdownGraceMillis;
    }

    public long getSchedulerInitializationBackoffTimeMillis() {
        return this.schedulerInitializationBackoffTimeMillis;
    }

    public KinesisClientLibConfiguration withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public KinesisClientLibConfiguration withKinesisEndpoint(String kinesisEndpoint) {
        this.kinesisEndpoint = kinesisEndpoint;
        return this;
    }

    public KinesisClientLibConfiguration withDynamoDBEndpoint(String dynamoDBEndpoint) {
        this.dynamoDBEndpoint = dynamoDBEndpoint;
        return this;
    }

    public KinesisClientLibConfiguration withInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPosition((InitialPositionInStream)initialPositionInStream);
        return this;
    }

    public KinesisClientLibConfiguration withTimestampAtInitialPositionInStream(Date timestamp) {
        this.initialPositionInStream = InitialPositionInStream.AT_TIMESTAMP;
        this.initialPositionInStreamExtended = InitialPositionInStreamExtended.newInitialPositionAtTimestamp((Date)timestamp);
        return this;
    }

    public KinesisClientLibConfiguration withFailoverTimeMillis(long failoverTimeMillis) {
        this.checkIsValuePositive("FailoverTimeMillis", failoverTimeMillis);
        this.failoverTimeMillis = failoverTimeMillis;
        return this;
    }

    public KinesisClientLibConfiguration withEnablePriorityLeaseAssignment(boolean enablePriorityLeaseAssignment) {
        this.enablePriorityLeaseAssignment = enablePriorityLeaseAssignment;
        return this;
    }

    public KinesisClientLibConfiguration withShardSyncIntervalMillis(long shardSyncIntervalMillis) {
        this.checkIsValuePositive("ShardSyncIntervalMillis", shardSyncIntervalMillis);
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMaxRecords(int maxRecords) {
        this.checkIsValuePositive("MaxRecords", maxRecords);
        if (maxRecords > 10000) {
            throw new IllegalArgumentException("maxRecords must be less than or equal to 10000 but current value is " + maxRecords);
        }
        this.maxRecords = maxRecords;
        return this;
    }

    public KinesisClientLibConfiguration withIdleTimeBetweenReadsInMillis(long idleTimeBetweenReadsInMillis) {
        this.checkIsValuePositive("IdleTimeBetweenReadsInMillis", idleTimeBetweenReadsInMillis);
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        return this;
    }

    public KinesisClientLibConfiguration withCallProcessRecordsEvenForEmptyRecordList(boolean callProcessRecordsEvenForEmptyRecordList) {
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        return this;
    }

    public KinesisClientLibConfiguration withParentShardPollIntervalMillis(long parentShardPollIntervalMillis) {
        this.checkIsValuePositive("ParentShardPollIntervalMillis", parentShardPollIntervalMillis);
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        return this;
    }

    public KinesisClientLibConfiguration withCleanupLeasesUponShardCompletion(boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        return this;
    }

    public KinesisClientLibConfiguration withIgnoreUnexpectedChildShards(boolean ignoreUnexpectedChildShards) {
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        return this;
    }

    public KinesisClientLibConfiguration withUserAgent(String userAgent) {
        String customizedUserAgent = userAgent + "," + KINESIS_CLIENT_LIB_USER_AGENT;
        return this;
    }

    public KinesisClientLibConfiguration withTaskBackoffTimeMillis(long taskBackoffTimeMillis) {
        this.checkIsValuePositive("TaskBackoffTimeMillis", taskBackoffTimeMillis);
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMetricsBufferTimeMillis(long metricsBufferTimeMillis) {
        this.checkIsValuePositive("MetricsBufferTimeMillis", metricsBufferTimeMillis);
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMetricsMaxQueueSize(int metricsMaxQueueSize) {
        this.checkIsValuePositive("MetricsMaxQueueSize", metricsMaxQueueSize);
        this.metricsMaxQueueSize = metricsMaxQueueSize;
        return this;
    }

    public KinesisClientLibConfiguration withMetricsLevel(MetricsLevel metricsLevel) {
        this.metricsLevel = metricsLevel == null ? DEFAULT_METRICS_LEVEL : metricsLevel;
        return this;
    }

    public KinesisClientLibConfiguration withMetricsLevel(String metricsLevel) {
        this.metricsLevel = MetricsLevel.fromName((String)metricsLevel);
        return this;
    }

    public KinesisClientLibConfiguration withMetricsEnabledDimensions(Set<String> metricsEnabledDimensions) {
        this.metricsEnabledDimensions = metricsEnabledDimensions == null ? METRICS_ALWAYS_ENABLED_DIMENSIONS : (metricsEnabledDimensions.contains("ALL") ? METRICS_DIMENSIONS_ALL : ImmutableSet.builder().addAll(metricsEnabledDimensions).addAll(METRICS_ALWAYS_ENABLED_DIMENSIONS).build());
        return this;
    }

    public KinesisClientLibConfiguration withValidateSequenceNumberBeforeCheckpointing(boolean validateSequenceNumberBeforeCheckpointing) {
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
        return this;
    }

    public KinesisClientLibConfiguration withSkipShardSyncAtStartupIfLeasesExist(boolean skipShardSyncAtStartupIfLeasesExist) {
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtStartupIfLeasesExist;
        return this;
    }

    public KinesisClientLibConfiguration withRegionName(String regionName) {
        this.checkIsRegionNameValid(regionName);
        this.regionName = regionName;
        return this;
    }

    public KinesisClientLibConfiguration withMaxLeasesForWorker(int maxLeasesForWorker) {
        this.checkIsValuePositive("maxLeasesForWorker", maxLeasesForWorker);
        this.maxLeasesForWorker = maxLeasesForWorker;
        return this;
    }

    public KinesisClientLibConfiguration withMaxLeasesToStealAtOneTime(int maxLeasesToStealAtOneTime) {
        this.checkIsValuePositive("maxLeasesToStealAtOneTime", maxLeasesToStealAtOneTime);
        this.maxLeasesToStealAtOneTime = maxLeasesToStealAtOneTime;
        return this;
    }

    public KinesisClientLibConfiguration withInitialLeaseTableReadCapacity(int initialLeaseTableReadCapacity) {
        this.checkIsValuePositive("initialLeaseTableReadCapacity", initialLeaseTableReadCapacity);
        this.initialLeaseTableReadCapacity = initialLeaseTableReadCapacity;
        return this;
    }

    public KinesisClientLibConfiguration withInitialLeaseTableWriteCapacity(int initialLeaseTableWriteCapacity) {
        this.checkIsValuePositive("initialLeaseTableWriteCapacity", initialLeaseTableWriteCapacity);
        this.initialLeaseTableWriteCapacity = initialLeaseTableWriteCapacity;
        return this;
    }

    public KinesisClientLibConfiguration withShardPrioritizationStrategy(ShardPrioritization shardPrioritization) {
        if (shardPrioritization == null) {
            throw new IllegalArgumentException("shardPrioritization cannot be null");
        }
        this.shardPrioritization = shardPrioritization;
        return this;
    }

    public KinesisClientLibConfiguration withMaxLeaseRenewalThreads(int maxLeaseRenewalThreads) {
        Validate.isTrue((maxLeaseRenewalThreads > 2 ? 1 : 0) != 0, (String)"The maximum number of lease renewal threads must be greater than or equal to 2.", (Object[])new Object[0]);
        this.maxLeaseRenewalThreads = maxLeaseRenewalThreads;
        return this;
    }

    public KinesisClientLibConfiguration withRetryGetRecordsInSeconds(int retryGetRecordsInSeconds) {
        this.checkIsValuePositive("retryGetRecordsInSeconds", retryGetRecordsInSeconds);
        this.retryGetRecordsInSeconds = Optional.of(retryGetRecordsInSeconds);
        return this;
    }

    public KinesisClientLibConfiguration withMaxGetRecordsThreadPool(int maxGetRecordsThreadPool) {
        this.checkIsValuePositive("maxGetRecordsThreadPool", maxGetRecordsThreadPool);
        this.maxGetRecordsThreadPool = Optional.of(maxGetRecordsThreadPool);
        return this;
    }

    public KinesisClientLibConfiguration withMaxPendingProcessRecordsInput(int maxPendingProcessRecordsInput) {
        this.checkIsValuePositive("maxPendingProcessRecordsInput", maxPendingProcessRecordsInput);
        this.recordsFetcherFactory.maxPendingProcessRecordsInput(maxPendingProcessRecordsInput);
        return this;
    }

    public KinesisClientLibConfiguration withMaxCacheByteSize(int maxCacheByteSize) {
        this.checkIsValuePositive("maxCacheByteSize", maxCacheByteSize);
        this.recordsFetcherFactory.maxByteSize(maxCacheByteSize);
        return this;
    }

    public KinesisClientLibConfiguration withDataFetchingStrategy(String dataFetchingStrategy) {
        this.recordsFetcherFactory.dataFetchingStrategy(DataFetchingStrategy.valueOf((String)dataFetchingStrategy.toUpperCase()));
        return this;
    }

    public KinesisClientLibConfiguration withMaxRecordsCount(int maxRecordsCount) {
        this.checkIsValuePositive("maxRecordsCount", maxRecordsCount);
        this.recordsFetcherFactory.maxRecordsCount(maxRecordsCount);
        return this;
    }

    public void withTimeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = Optional.of(timeoutInSeconds);
    }

    public KinesisClientLibConfiguration withShutdownGraceMillis(long shutdownGraceMillis) {
        this.checkIsValuePositive("ShutdownGraceMillis", shutdownGraceMillis);
        this.shutdownGraceMillis = shutdownGraceMillis;
        return this;
    }

    public KinesisClientLibConfiguration withIdleMillisBetweenCalls(long idleMillisBetweenCalls) {
        this.checkIsValuePositive("IdleMillisBetweenCalls", idleMillisBetweenCalls);
        this.recordsFetcherFactory.idleMillisBetweenCalls(idleMillisBetweenCalls);
        return this;
    }

    public KinesisClientLibConfiguration withLogWarningForTaskAfterMillis(long logWarningForTaskAfterMillis) {
        this.checkIsValuePositive("LogProcessTaskStatusAfterInMillis", logWarningForTaskAfterMillis);
        this.logWarningForTaskAfterMillis = Optional.of(logWarningForTaskAfterMillis);
        return this;
    }

    public KinesisClientLibConfiguration withListShardsBackoffTimeInMillis(long listShardsBackoffTimeInMillis) {
        this.checkIsValuePositive("listShardsBackoffTimeInMillis", listShardsBackoffTimeInMillis);
        this.listShardsBackoffTimeInMillis = listShardsBackoffTimeInMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMaxListShardsRetryAttempts(int maxListShardsRetryAttempts) {
        this.checkIsValuePositive("maxListShardsRetryAttempts", maxListShardsRetryAttempts);
        this.maxListShardsRetryAttempts = maxListShardsRetryAttempts;
        return this;
    }

    public KinesisClientLibConfiguration withSchedulerInitializationBackoffTimeMillis(long schedulerInitializationBackoffTimeMillis) {
        this.checkIsValuePositive("schedulerInitializationBackoffTimeMillis", schedulerInitializationBackoffTimeMillis);
        this.schedulerInitializationBackoffTimeMillis = schedulerInitializationBackoffTimeMillis;
        return this;
    }

    public Optional<Integer> getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public Optional<Integer> getRetryGetRecordsInSeconds() {
        return this.retryGetRecordsInSeconds;
    }

    public Optional<Integer> getMaxGetRecordsThreadPool() {
        return this.maxGetRecordsThreadPool;
    }

    public int getMaxLeaseRenewalThreads() {
        return this.maxLeaseRenewalThreads;
    }

    public RecordsFetcherFactory getRecordsFetcherFactory() {
        return this.recordsFetcherFactory;
    }

    public Optional<Long> getLogWarningForTaskAfterMillis() {
        return this.logWarningForTaskAfterMillis;
    }

    public long getListShardsBackoffTimeInMillis() {
        return this.listShardsBackoffTimeInMillis;
    }

    public int getMaxListShardsRetryAttempts() {
        return this.maxListShardsRetryAttempts;
    }
}

