/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.Util;

final class BundledRuntime {
    static String extract(Class<?> klass) {
        try {
            Path directory = Files.createTempDirectory("jsii-java-runtime", new FileAttribute[0]);
            directory.toFile().deleteOnExit();
            Path entrypoint = Util.extractResource(klass, "bin/jsii-runtime.js", directory);
            entrypoint.toFile().deleteOnExit();
            Util.extractResource(klass, "bin/jsii-runtime.js.map", directory).toFile().deleteOnExit();
            Util.extractResource(klass, "lib/program.js", directory).toFile().deleteOnExit();
            Util.extractResource(klass, "lib/program.js.map", directory).toFile().deleteOnExit();
            return entrypoint.toString();
        }
        catch (IOException ioe) {
            throw new JsiiException("Unable to extract bundled @jsii/runtime library", ioe);
        }
    }

    private BundledRuntime() {
    }
}

