/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import software.amazon.jsii.BundledRuntime;
import software.amazon.jsii.JsiiCallbackHandler;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiError;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.MessageInspector;
import software.amazon.jsii.NativeType;
import software.amazon.jsii.api.Callback;

public final class JsiiRuntime {
    private static final String VERSION_BUILD_PART_REGEX = "\\+[a-z0-9]+$";
    static final ThreadLocal<MessageInspector> messageInspector = new ThreadLocal();
    private JsiiClient client;
    private Process childProcess;
    private BufferedReader stdout;
    private Writer stdin;
    private ErrorStreamSink errorStreamSink;
    private JsiiCallbackHandler callbackHandler;
    private Thread shutdownHook;
    @Nullable
    private final String customRuntime;
    @Nullable
    private final String customNode;

    public JsiiRuntime() {
        this(System.getenv("JSII_RUNTIME"), System.getenv("JSII_NODE"));
    }

    @VisibleForTesting
    JsiiRuntime(@Nullable String customRuntime, @Nullable String customNode) {
        this.customRuntime = customRuntime;
        this.customNode = customNode;
    }

    JsonNode requestResponse(JsonNode request) {
        try {
            JsiiRuntime.notifyInspector(request, MessageInspector.MessageType.Request);
            String str = request.toString();
            this.stdin.write(str + "\n");
            this.stdin.flush();
            JsonNode resp = this.readNextResponse();
            if (resp.has("error")) {
                return this.processErrorResponse(resp);
            }
            if (resp.has("callback")) {
                return this.processCallbackResponse(resp);
            }
            return resp.get("ok");
        }
        catch (IOException e) {
            throw new JsiiError("Unable to send request to jsii-runtime: " + e.toString(), e);
        }
    }

    private JsonNode processErrorResponse(JsonNode resp) {
        String errorName = resp.get("name").asText();
        String errorMessage = resp.get("error").asText();
        if (resp.has("stack")) {
            errorMessage = errorMessage + "\n" + resp.get("stack").asText();
        }
        if (errorName.equals(JsiiException.Type.RUNTIME_ERROR.toString())) {
            throw new RuntimeException(errorMessage);
        }
        throw new JsiiError(errorMessage);
    }

    private JsonNode processCallbackResponse(JsonNode resp) {
        if (this.callbackHandler == null) {
            throw new JsiiError("Cannot process callback since callbackHandler was not set");
        }
        Callback callback = JsiiObjectMapper.treeToValue(resp.get("callback"), NativeType.forClass(Callback.class));
        JsonNode result = null;
        String error = null;
        String name = null;
        try {
            result = this.callbackHandler.handleCallback(callback);
        }
        catch (Exception e) {
            error = e.getCause() instanceof InvocationTargetException ? e.getCause().getCause().getMessage() : e.getMessage();
            name = e instanceof JsiiError ? JsiiException.Type.JSII_FAULT.toString() : JsiiException.Type.RUNTIME_ERROR.toString();
        }
        ObjectNode completeResponse = JsonNodeFactory.instance.objectNode();
        completeResponse.put("cbid", callback.getCbid());
        if (error != null) {
            completeResponse.put("err", error);
            completeResponse.put("name", name);
        }
        if (result != null) {
            completeResponse.set("result", result);
        }
        ObjectNode req = JsonNodeFactory.instance.objectNode();
        req.set("complete", (JsonNode)completeResponse);
        return this.requestResponse((JsonNode)req);
    }

    public void setCallbackHandler(JsiiCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    protected void finalize() throws Throwable {
        try {
            this.terminate();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void terminate() {
        if (this.stdin != null) {
            try {
                this.stdin.write("{\"exit\":0}\n");
                this.stdin.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.stdin = null;
            }
        }
        if (this.stdout != null) {
            try {
                this.stdout.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.stdout = null;
            }
        }
        if (this.errorStreamSink != null) {
            try {
                this.errorStreamSink.close();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.errorStreamSink = null;
            }
        }
        if (this.childProcess != null) {
            try {
                if (!this.childProcess.waitFor(5L, TimeUnit.SECONDS)) {
                    this.childProcess.destroyForcibly();
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            finally {
                this.childProcess = null;
            }
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                this.shutdownHook = null;
            }
        }
    }

    private synchronized void startRuntimeIfNeeded() {
        if (this.childProcess != null) {
            return;
        }
        String jsiiDebug = System.getenv("JSII_DEBUG");
        boolean traceEnabled = jsiiDebug != null && !jsiiDebug.isEmpty() && !jsiiDebug.equalsIgnoreCase("false") && !jsiiDebug.equalsIgnoreCase("0");
        List<String> jsiiRuntimeCommand = this.jsiiRuntimeCommand();
        if (traceEnabled) {
            System.err.println("jsii-runtime: " + String.join((CharSequence)" ", jsiiRuntimeCommand));
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(jsiiRuntimeCommand).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.PIPE);
            pb.environment().put("JSII_AGENT", String.format("Java/%s", System.getProperty("java.version")));
            if (jsiiDebug != null) {
                pb.environment().put("JSII_DEBUG", jsiiDebug);
            }
            this.childProcess = pb.start();
            this.stdin = new OutputStreamWriter(this.childProcess.getOutputStream(), StandardCharsets.UTF_8);
            this.stdout = new BufferedReader(new InputStreamReader(this.childProcess.getInputStream(), StandardCharsets.UTF_8));
            this.errorStreamSink = new ErrorStreamSink(this.childProcess.getErrorStream());
            this.errorStreamSink.start();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        this.shutdownHook = new Thread(this::terminate, "Terminate jsii client");
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.handshake();
        this.client = new JsiiClient(this);
    }

    private List<String> jsiiRuntimeCommand() {
        if (this.customRuntime != null) {
            if (this.customRuntime.matches(".*\\s.*")) {
                return JsiiRuntime.shellOut(this.customRuntime);
            }
            return Collections.singletonList(this.customRuntime);
        }
        String bundledRuntime = BundledRuntime.extract(JsiiRuntime.class);
        if (this.customNode != null && this.customNode.matches(".*\\s.*")) {
            return JsiiRuntime.shellOut(this.customNode, bundledRuntime);
        }
        return Arrays.asList(this.customNode != null ? this.customNode : "node", bundledRuntime);
    }

    private static List<String> shellOut(String ... command) {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        if (isWindows) {
            String cmd = System.getenv("COMSPEC");
            if (cmd == null) {
                cmd = "cmd.exe";
            }
            return Arrays.asList(cmd, "/d", "/s", "/c", String.join((CharSequence)" ", command));
        }
        return Arrays.asList("/bin/sh", "-c", String.join((CharSequence)" ", command));
    }

    private void handshake() {
        JsonNode helloResponse = this.readNextResponse();
        if (!helloResponse.has("hello")) {
            throw new JsiiError("Expecting 'hello' message from jsii-runtime");
        }
        String runtimeVersion = helloResponse.get("hello").asText();
        JsiiRuntime.assertVersionCompatible("@jsii/runtime@1.105.0", runtimeVersion);
    }

    JsonNode readNextResponse() {
        try {
            String responseLine = this.stdout.readLine();
            if (responseLine == null) {
                throw new JsiiError("Child process exited unexpectedly!");
            }
            JsonNode response = JsiiObjectMapper.INSTANCE.readTree(responseLine);
            JsiiRuntime.notifyInspector(response, MessageInspector.MessageType.Response);
            return response;
        }
        catch (IOException e) {
            throw new JsiiError("Unable to read reply from jsii-runtime: " + e.toString(), e);
        }
    }

    public JsiiClient getClient() {
        this.startRuntimeIfNeeded();
        if (this.client == null) {
            throw new JsiiError("Client not created");
        }
        return this.client;
    }

    static void assertVersionCompatible(String expectedVersion, String actualVersion) {
        String shortActualVersion = actualVersion.replaceAll(VERSION_BUILD_PART_REGEX, "");
        String shortExpectedVersion = expectedVersion.replaceAll(VERSION_BUILD_PART_REGEX, "");
        if (shortExpectedVersion.compareTo(shortActualVersion) != 0) {
            throw new JsiiError("Incompatible jsii-runtime version. Expecting " + shortExpectedVersion + ", actual was " + shortActualVersion);
        }
    }

    private static void notifyInspector(JsonNode message, MessageInspector.MessageType type) {
        MessageInspector inspector = messageInspector.get();
        if (inspector == null) {
            return;
        }
        inspector.inspect(message, type);
    }

    private static final class ErrorStreamSink
    extends Thread {
        private final ObjectMapper objectMapper = new ObjectMapper();
        private final InputStream inputStream;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private boolean eof = false;
        private boolean stop = false;

        public ErrorStreamSink(InputStream inputStream) {
            this.inputStream = inputStream;
            this.setDaemon(true);
            this.setName(this.getClass().getCanonicalName());
            this.setUncaughtExceptionHandler((thread, throwable) -> System.err.printf("Unexpected error in background thread \"%s\": %s%n", thread.getName(), throwable));
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    this.acceptData(false);
                    if (this.stop) continue;
                    Thread.sleep(100L);
                }
                this.acceptData(true);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void close() throws InterruptedException {
            this.stop = true;
            this.join();
        }

        private void acceptData(boolean uninterruptible) throws IOException {
            while (!this.eof && (uninterruptible || this.inputStream.available() > 0)) {
                int read = this.inputStream.read();
                if (read == -1) {
                    this.eof = true;
                } else {
                    this.buffer.write(read);
                }
                if (read != 10 && !this.eof) continue;
                this.processLine(new String(this.buffer.toByteArray(), StandardCharsets.UTF_8));
                this.buffer.reset();
            }
        }

        private void processLine(String line) {
            try {
                JsonNode tree = this.objectMapper.readTree(line);
                ConsoleOutput consoleOutput = (ConsoleOutput)this.objectMapper.treeToValue((TreeNode)tree, ConsoleOutput.class);
                if (consoleOutput.stderr != null) {
                    System.err.write(consoleOutput.stderr, 0, consoleOutput.stderr.length);
                }
                if (consoleOutput.stdout != null) {
                    System.out.write(consoleOutput.stdout, 0, consoleOutput.stdout.length);
                }
            }
            catch (JsonProcessingException exception) {
                System.err.println(line);
            }
        }
    }

    private static final class ConsoleOutput {
        @Nullable
        public final byte[] stderr;
        @Nullable
        public final byte[] stdout;

        @JsonCreator
        public ConsoleOutput(@JsonProperty(value="stderr") @Nullable byte[] stderr, @JsonProperty(value="stdout") @Nullable byte[] stdout) {
            this.stderr = stderr;
            this.stdout = stdout;
        }
    }
}

