/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import software.amazon.jsii.JsiiException;

final class Util {
    static final int PROPERTY_METHOD_PREFIX_LEN = 3;

    private Util() {
    }

    static String readString(InputStream is) {
        try (Scanner s = new Scanner(is, "UTF-8");){
            s.useDelimiter("\\A");
            if (s.hasNext()) {
                String string = s.next();
                return string;
            }
            String string = "";
            return string;
        }
    }

    static boolean isJavaPropertyMethod(String methodName) {
        return methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"));
    }

    static String javaPropertyToJSProperty(String getterSetterMethod) {
        if (!Util.isJavaPropertyMethod(getterSetterMethod)) {
            throw new JsiiException("Invalid getter/setter method. Must start with get/set");
        }
        String camelCase = getterSetterMethod.substring(3, 4).toLowerCase();
        if (getterSetterMethod.length() > 4) {
            camelCase = camelCase + getterSetterMethod.substring(4);
        }
        return camelCase;
    }

    static String javaScriptPropertyToJavaPropertyName(String prefix, String jsPropertyName) {
        if (jsPropertyName.isEmpty()) {
            throw new JsiiException("jsPropertyName must not be empty");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(jsPropertyName.substring(0, 1).toUpperCase());
        if (jsPropertyName.length() > 1) {
            sb.append(jsPropertyName.substring(1));
        }
        return sb.toString();
    }

    static String extractResource(Class<?> klass, String resourceName, String outputDirectory) throws IOException {
        String directory = outputDirectory;
        if (directory == null) {
            directory = Files.createTempDirectory("jsii-java-runtime-resource", new FileAttribute[0]).toString();
        }
        Path target = Paths.get(directory, resourceName);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (InputStream inputStream = klass.getResourceAsStream(resourceName);){
            Files.copy(inputStream, target, new CopyOption[0]);
        }
        return target.toAbsolutePath().toString();
    }
}

