/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.SQLType;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class SQLTypeWrapper
implements SQLType {
    protected final SQLType sqlType;
    protected final ConnectionWrapper connectionWrapper;
    protected final ConnectionPluginManager pluginManager;

    public SQLTypeWrapper(@NonNull SQLType sqlType, @NonNull ConnectionWrapper connectionWrapper, @NonNull ConnectionPluginManager pluginManager) {
        this.sqlType = sqlType;
        this.connectionWrapper = connectionWrapper;
        this.pluginManager = pluginManager;
    }

    @Override
    public String getName() {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SQLTYPE_GETNAME)) {
            return WrapperUtils.executeWithPlugins(String.class, this.connectionWrapper, this.pluginManager, this.sqlType, JdbcMethod.SQLTYPE_GETNAME, this.sqlType::getName, new Object[0]);
        }
        return this.sqlType.getName();
    }

    @Override
    public String getVendor() {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SQLTYPE_GETVENDOR)) {
            return WrapperUtils.executeWithPlugins(String.class, this.connectionWrapper, this.pluginManager, this.sqlType, JdbcMethod.SQLTYPE_GETVENDOR, this.sqlType::getVendor, new Object[0]);
        }
        return this.sqlType.getVendor();
    }

    @Override
    public Integer getVendorTypeNumber() {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SQLTYPE_GETVENDORTYPENUMBER)) {
            return WrapperUtils.executeWithPlugins(Integer.class, this.connectionWrapper, this.pluginManager, this.sqlType, JdbcMethod.SQLTYPE_GETVENDORTYPENUMBER, this.sqlType::getVendorTypeNumber, new Object[0]);
        }
        return this.sqlType.getVendorTypeNumber();
    }

    public String toString() {
        return super.toString() + " - " + this.sqlType;
    }
}

