/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import software.amazon.jdbc.util.storage.CacheItem;
import software.amazon.jdbc.util.storage.ItemDisposalFunc;
import software.amazon.jdbc.util.storage.ShouldDisposeFunc;

public class SlidingExpirationCache<K, V> {
    protected final Map<K, CacheItem<V>> cache = new ConcurrentHashMap<K, CacheItem<V>>();
    protected long cleanupIntervalNanos = TimeUnit.MINUTES.toNanos(10L);
    protected final AtomicLong cleanupTimeNanos = new AtomicLong(System.nanoTime() + this.cleanupIntervalNanos);
    protected final AtomicReference<ShouldDisposeFunc<V>> shouldDisposeFunc = new AtomicReference<Object>(null);
    protected final ItemDisposalFunc<V> itemDisposalFunc;

    public SlidingExpirationCache() {
        this.shouldDisposeFunc.set(null);
        this.itemDisposalFunc = null;
    }

    public SlidingExpirationCache(ShouldDisposeFunc<V> shouldDisposeFunc, ItemDisposalFunc<V> itemDisposalFunc) {
        this.shouldDisposeFunc.set(shouldDisposeFunc);
        this.itemDisposalFunc = itemDisposalFunc;
    }

    public SlidingExpirationCache(ShouldDisposeFunc<V> shouldDisposeFunc, ItemDisposalFunc<V> itemDisposalFunc, long cleanupIntervalNanos) {
        this.shouldDisposeFunc.set(shouldDisposeFunc);
        this.itemDisposalFunc = itemDisposalFunc;
        this.cleanupIntervalNanos = cleanupIntervalNanos;
    }

    public void setShouldDisposeFunc(ShouldDisposeFunc<V> shouldDisposeFunc) {
        this.shouldDisposeFunc.set(shouldDisposeFunc);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long itemExpirationNano) {
        this.cleanUp();
        CacheItem cacheItem = this.cache.computeIfAbsent(key, k -> new CacheItem(mappingFunction.apply((K)k), System.nanoTime() + itemExpirationNano, this.shouldDisposeFunc.get()));
        cacheItem.extendExpiration(itemExpirationNano);
        return cacheItem.item;
    }

    public V put(K key, V value, long itemExpirationNano) {
        this.cleanUp();
        CacheItem<V> cacheItem = this.cache.put(key, new CacheItem<V>(value, System.nanoTime() + itemExpirationNano));
        if (cacheItem == null) {
            return null;
        }
        cacheItem.extendExpiration(itemExpirationNano);
        return cacheItem.item;
    }

    public V get(K key, long itemExpirationNano) {
        this.cleanUp();
        CacheItem<V> cacheItem = this.cache.get(key);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.extendExpiration(itemExpirationNano);
        return cacheItem.item;
    }

    public void remove(K key) {
        this.removeAndDispose(key);
        this.cleanUp();
    }

    protected void removeAndDispose(K key) {
        CacheItem<V> cacheItem = this.cache.remove(key);
        if (cacheItem != null && this.itemDisposalFunc != null) {
            this.itemDisposalFunc.dispose(cacheItem.item);
        }
    }

    protected void removeIfExpired(K key) {
        ArrayList itemList = new ArrayList(1);
        this.cache.computeIfPresent(key, (k, cacheItem) -> {
            if (cacheItem.shouldCleanup()) {
                itemList.add(cacheItem.item);
                return null;
            }
            return cacheItem;
        });
        if (itemList.isEmpty()) {
            return;
        }
        Object item = itemList.get(0);
        if (item != null && this.itemDisposalFunc != null) {
            this.itemDisposalFunc.dispose(item);
        }
    }

    public void clear() {
        for (K key : this.cache.keySet()) {
            this.removeAndDispose(key);
        }
        this.cache.clear();
    }

    public Map<K, V> getEntries() {
        HashMap entries = new HashMap();
        for (Map.Entry<K, CacheItem<V>> entry : this.cache.entrySet()) {
            entries.put(entry.getKey(), entry.getValue().item);
        }
        return entries;
    }

    public int size() {
        return this.cache.size();
    }

    protected void cleanUp() {
        if (this.cleanupTimeNanos.get() > System.nanoTime()) {
            return;
        }
        this.cleanupTimeNanos.set(System.nanoTime() + this.cleanupIntervalNanos);
        this.cache.forEach((key, value) -> this.removeIfExpired(key));
    }

    public void setCleanupIntervalNanos(long cleanupIntervalNanos) {
        this.cleanupIntervalNanos = cleanupIntervalNanos;
        this.cleanupTimeNanos.set(System.nanoTime() + cleanupIntervalNanos);
    }

    Map<K, CacheItem<V>> getCache() {
        return this.cache;
    }
}

