/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.ds;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.DataSourceConnectionProvider;
import software.amazon.jdbc.Driver;
import software.amazon.jdbc.DriverConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.TargetDriverHelper;
import software.amazon.jdbc.authentication.AwsCredentialsManager;
import software.amazon.jdbc.ds.AwsWrapperDataSourceFactory;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.profile.DriverConfigurationProfiles;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialectManager;
import software.amazon.jdbc.util.ConnectionUrlBuilder;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.CoreServicesContainer;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.ServiceUtility;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.monitoring.MonitorService;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.DefaultTelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class AwsWrapperDataSource
implements DataSource,
Referenceable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(AwsWrapperDataSource.class.getName());
    private static final String PROTOCOL_PREFIX = "jdbc:aws-wrapper:";
    private static final String SERVER_NAME = "serverName";
    private static final String SERVER_PORT = "serverPort";
    private final ConnectionUrlParser urlParser = new ConnectionUrlParser();
    private final StorageService storageService;
    private final MonitorService monitorService;
    protected transient @Nullable PrintWriter logWriter;
    protected @Nullable String user;
    protected @Nullable String password;
    protected @Nullable String jdbcUrl;
    protected @Nullable String targetDataSourceClassName;
    protected @Nullable Properties targetDataSourceProperties;
    protected @Nullable String jdbcProtocol;
    protected @Nullable String serverName;
    protected @Nullable String serverPort;
    protected @Nullable String database;
    private int loginTimeout = 0;

    public AwsWrapperDataSource() {
        this(CoreServicesContainer.getInstance());
    }

    public AwsWrapperDataSource(CoreServicesContainer coreServicesContainer) {
        this.storageService = coreServicesContainer.getStorageService();
        this.monitorService = coreServicesContainer.getMonitorService();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.setCredentialPropertiesFromUrl(this.jdbcUrl);
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.user = username;
        this.password = password;
        Properties props = PropertyUtils.copyProperties(this.targetDataSourceProperties);
        String registerPackageNames = PropertyDefinition.SKIP_WRAPPING_FOR_PACKAGES.getString(props);
        if (!StringUtils.isNullOrEmpty(registerPackageNames)) {
            String[] packages;
            for (String packageName : packages = registerPackageNames.split(",")) {
                Driver.skipWrappingForPackage(packageName);
            }
        }
        String profileName = PropertyDefinition.PROFILE_NAME.getString(props);
        ConfigurationProfile configurationProfile = null;
        if (!StringUtils.isNullOrEmpty(profileName)) {
            configurationProfile = DriverConfigurationProfiles.getProfileConfiguration(profileName);
            if (configurationProfile != null) {
                PropertyUtils.addProperties(props, configurationProfile.getProperties());
                if (configurationProfile.getAwsCredentialsProviderHandler() != null) {
                    AwsCredentialsManager.setCustomHandler(configurationProfile.getAwsCredentialsProviderHandler());
                }
            } else {
                throw new SQLException(Messages.get("AwsWrapperDataSource.configurationProfileNotFound", new Object[]{profileName}));
            }
        }
        DefaultTelemetryFactory telemetryFactory = new DefaultTelemetryFactory(props);
        TelemetryContext context = telemetryFactory.openTelemetryContext("software.amazon.jdbc.ds.AwsWrapperDataSource.getConnection", TelemetryTraceLevel.TOP_LEVEL);
        try {
            String finalUrl;
            if (!StringUtils.isNullOrEmpty(this.jdbcUrl)) {
                finalUrl = this.jdbcUrl.replaceFirst(PROTOCOL_PREFIX, "jdbc:");
                ConnectionUrlParser.parsePropertiesFromUrl(this.jdbcUrl, props);
                this.setDatabasePropertyFromUrl(props);
                this.setCredentialProperties(props);
                if (!StringUtils.isNullOrEmpty(this.database)) {
                    PropertyDefinition.DATABASE.set(props, this.database);
                }
            } else {
                String databaseName;
                String serverName = !StringUtils.isNullOrEmpty(this.serverName) ? this.serverName : props.getProperty(SERVER_NAME);
                String serverPort = !StringUtils.isNullOrEmpty(this.serverPort) ? this.serverPort : props.getProperty(SERVER_PORT);
                String string = databaseName = !StringUtils.isNullOrEmpty(this.database) ? this.database : PropertyDefinition.DATABASE.getString(props);
                if (StringUtils.isNullOrEmpty(serverName)) {
                    throw new SQLException(Messages.get("AwsWrapperDataSource.missingTarget"));
                }
                if (StringUtils.isNullOrEmpty(this.jdbcProtocol)) {
                    throw new SQLException(Messages.get("AwsWrapperDataSource.missingJdbcProtocol"));
                }
                int port = -1;
                if (!StringUtils.isNullOrEmpty(serverPort)) {
                    port = Integer.parseInt(serverPort);
                }
                finalUrl = ConnectionUrlBuilder.buildUrl(this.jdbcProtocol, serverName, port, databaseName);
                this.setCredentialProperties(props);
                if (!StringUtils.isNullOrEmpty(databaseName)) {
                    PropertyDefinition.DATABASE.set(props, databaseName);
                }
            }
            TargetDriverDialect targetDriverDialect = configurationProfile == null ? null : configurationProfile.getTargetDriverDialect();
            ConnectionProvider effectiveConnectionProvider = null;
            if (configurationProfile != null) {
                effectiveConnectionProvider = configurationProfile.getConnectionProvider();
            }
            if (!StringUtils.isNullOrEmpty(this.targetDataSourceClassName)) {
                DataSource targetDataSource = this.createTargetDataSource();
                try {
                    targetDataSource.setLoginTimeout(this.loginTimeout);
                }
                catch (Exception ex) {
                    LOGGER.finest(() -> Messages.get("DataSource.failedToSetProperty", new Object[]{"loginTimeout", targetDataSource.getClass(), ex.getCause().getMessage()}));
                }
                if (targetDriverDialect == null) {
                    TargetDriverDialectManager targetDriverDialectManager = new TargetDriverDialectManager();
                    targetDriverDialect = targetDriverDialectManager.getDialect(this.targetDataSourceClassName, props);
                }
                DataSourceConnectionProvider defaultConnectionProvider = new DataSourceConnectionProvider(targetDataSource);
                ConnectionWrapper connectionWrapper = this.createConnectionWrapper(props, finalUrl, defaultConnectionProvider, effectiveConnectionProvider, targetDriverDialect, configurationProfile, telemetryFactory);
                return connectionWrapper;
            }
            TargetDriverHelper helper = new TargetDriverHelper();
            java.sql.Driver targetDriver = helper.getTargetDriver(finalUrl, props);
            if (targetDriverDialect == null) {
                TargetDriverDialectManager targetDriverDialectManager = new TargetDriverDialectManager();
                targetDriverDialect = targetDriverDialectManager.getDialect(targetDriver, props);
            }
            DriverConnectionProvider defaultConnectionProvider = new DriverConnectionProvider(targetDriver);
            ConnectionWrapper connectionWrapper = this.createConnectionWrapper(props, finalUrl, defaultConnectionProvider, effectiveConnectionProvider, targetDriverDialect, configurationProfile, telemetryFactory);
            return connectionWrapper;
        }
        catch (Exception ex) {
            if (context != null) {
                context.setException(ex);
                context.setSuccess(false);
            }
            throw ex;
        }
        finally {
            if (context != null) {
                context.closeContext();
            }
        }
    }

    ConnectionWrapper createConnectionWrapper(Properties props, String url, @NonNull ConnectionProvider defaultProvider, @Nullable ConnectionProvider effectiveProvider, @NonNull TargetDriverDialect targetDriverDialect, @Nullable ConfigurationProfile configurationProfile, TelemetryFactory telemetryFactory) throws SQLException {
        String targetProtocol = this.urlParser.getProtocol(url);
        FullServicesContainer servicesContainer = ServiceUtility.getInstance().createStandardServiceContainer(this.storageService, this.monitorService, defaultProvider, effectiveProvider, telemetryFactory, url, targetProtocol, targetDriverDialect, props, configurationProfile);
        return new ConnectionWrapper(servicesContainer, props, url, targetProtocol, configurationProfile);
    }

    public void setTargetDataSourceClassName(@Nullable String dataSourceClassName) {
        this.targetDataSourceClassName = dataSourceClassName;
    }

    public @Nullable String getTargetDataSourceClassName() {
        return this.targetDataSourceClassName;
    }

    public void setServerName(@NonNull String serverName) {
        this.serverName = serverName;
    }

    public @Nullable String getServerName() {
        return this.serverName;
    }

    public void setServerPort(@NonNull String serverPort) {
        this.serverPort = serverPort;
    }

    public @Nullable String getServerPort() {
        return this.serverPort;
    }

    public void setDatabase(@NonNull String database) {
        this.database = database;
    }

    public @Nullable String getDatabase() {
        return this.database;
    }

    public void setJdbcUrl(@Nullable String url) {
        this.jdbcUrl = url;
    }

    public @Nullable String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcProtocol(@NonNull String jdbcProtocol) {
        this.jdbcProtocol = jdbcProtocol;
    }

    public @Nullable String getJdbcProtocol() {
        return this.jdbcProtocol;
    }

    public void setTargetDataSourceProperties(@Nullable Properties dataSourceProps) {
        this.targetDataSourceProperties = dataSourceProps;
    }

    public @Nullable Properties getTargetDataSourceProperties() {
        return this.targetDataSourceProperties;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Login timeout cannot be a negative value.");
        }
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), AwsWrapperDataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("jdbcUrl", this.getJdbcUrl()));
        reference.add(new StringRefAddr("targetDataSourceClassName", this.getTargetDataSourceClassName()));
        reference.add(new StringRefAddr("jdbcProtocol", this.getJdbcProtocol()));
        reference.add(new StringRefAddr(SERVER_NAME, this.getServerName()));
        reference.add(new StringRefAddr(SERVER_PORT, this.getServerPort()));
        reference.add(new StringRefAddr("database", this.getDatabase()));
        if (this.targetDataSourceProperties != null) {
            for (Map.Entry<Object, Object> entry : this.targetDataSourceProperties.entrySet()) {
                reference.add(new StringRefAddr(entry.getKey().toString(), entry.getValue().toString()));
            }
        }
        return reference;
    }

    private void setCredentialProperties(Properties props) {
        if (!StringUtils.isNullOrEmpty(this.user)) {
            PropertyDefinition.USER.set(props, this.user);
        }
        if (!StringUtils.isNullOrEmpty(this.password)) {
            PropertyDefinition.PASSWORD.set(props, this.password);
        }
    }

    DataSource createTargetDataSource() throws SQLException {
        try {
            return WrapperUtils.createInstance(this.targetDataSourceClassName, DataSource.class, new Object[0]);
        }
        catch (InstantiationException instEx) {
            throw new SQLException(instEx.getMessage(), SqlState.UNKNOWN_STATE.getState(), instEx);
        }
    }

    private void setDatabasePropertyFromUrl(Properties props) {
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(this.jdbcUrl);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(props, databaseName);
        }
    }

    private void setCredentialPropertiesFromUrl(String jdbcUrl) {
        if (StringUtils.isNullOrEmpty(jdbcUrl)) {
            return;
        }
        if (StringUtils.isNullOrEmpty(this.user)) {
            this.user = ConnectionUrlParser.parseUserFromUrl(jdbcUrl);
        }
        if (StringUtils.isNullOrEmpty(this.password)) {
            this.password = ConnectionUrlParser.parsePasswordFromUrl(jdbcUrl);
        }
    }

    static {
        try {
            if (!Driver.isRegistered()) {
                Driver.register();
            }
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

