/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessQueryHelper;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterServiceImpl;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class LimitlessRouterMonitor
implements AutoCloseable,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(LimitlessRouterMonitor.class.getName());
    protected static final String MONITORING_PROPERTY_PREFIX = "limitless-router-monitor-";
    protected final int intervalMs;
    protected final @NonNull HostSpec hostSpec;
    protected final SlidingExpirationCacheWithCleanupThread<String, List<HostSpec>> limitlessRouterCache;
    protected final String limitlessRouterCacheKey;
    protected final @NonNull Properties props;
    protected final @NonNull PluginService pluginService;
    protected final LimitlessQueryHelper queryHelper;
    protected final TelemetryFactory telemetryFactory;
    protected Connection monitoringConn = null;
    private final ExecutorService threadPool = ExecutorFactory.newFixedThreadPool(1, "threadPool");
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    public LimitlessRouterMonitor(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull SlidingExpirationCacheWithCleanupThread<String, List<HostSpec>> limitlessRouterCache, @NonNull String limitlessRouterCacheKey, @NonNull Properties props, int intervalMs) {
        this.pluginService = pluginService;
        this.hostSpec = hostSpec;
        this.limitlessRouterCache = limitlessRouterCache;
        this.limitlessRouterCacheKey = limitlessRouterCacheKey;
        this.props = PropertyUtils.copyProperties(props);
        props.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
            this.props.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.props.getProperty((String)p));
            this.props.remove(p);
        });
        this.props.setProperty(LimitlessConnectionPlugin.WAIT_FOR_ROUTER_INFO.name, "false");
        this.intervalMs = intervalMs;
        this.telemetryFactory = this.pluginService.getTelemetryFactory();
        this.queryHelper = new LimitlessQueryHelper(this.pluginService);
        this.threadPool.submit(this);
        this.threadPool.shutdown();
    }

    public List<HostSpec> getLimitlessRouters() {
        return (List)this.limitlessRouterCache.get(this.limitlessRouterCacheKey, TimeUnit.MILLISECONDS.toNanos(LimitlessRouterServiceImpl.MONITOR_DISPOSAL_TIME_MS.getLong(this.props)));
    }

    public AtomicBoolean isStopped() {
        return this.stopped;
    }

    @Override
    public void close() throws Exception {
        this.stopped.set(true);
        try {
            if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                this.monitoringConn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.monitoringConn = null;
        if (!this.threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
            this.threadPool.shutdownNow();
        }
        LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.stopped", new Object[]{this.hostSpec.getHost()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.running", new Object[]{this.hostSpec.getHost()}));
        try {
            while (!this.stopped.get()) {
                TelemetryContext telemetryContext = this.telemetryFactory.openTelemetryContext("limitless router monitor thread", TelemetryTraceLevel.TOP_LEVEL);
                telemetryContext.setAttribute("url", this.hostSpec.getUrl());
                try {
                    this.openConnection();
                    if (this.monitoringConn == null || this.monitoringConn.isClosed()) continue;
                    List<HostSpec> newLimitlessRouters = this.queryHelper.queryForLimitlessRouters(this.monitoringConn, this.hostSpec.getPort());
                    this.limitlessRouterCache.put(this.limitlessRouterCacheKey, newLimitlessRouters, TimeUnit.MILLISECONDS.toNanos(LimitlessRouterServiceImpl.MONITOR_DISPOSAL_TIME_MS.getLong(this.props)));
                    LOGGER.finest(Utils.logTopology(newLimitlessRouters, "[limitlessRouterMonitor] Topology:"));
                    TimeUnit.MILLISECONDS.sleep(this.intervalMs);
                }
                catch (Exception ex) {
                    if (telemetryContext == null) throw ex;
                    telemetryContext.setException(ex);
                    telemetryContext.setSuccess(false);
                    throw ex;
                }
                finally {
                    if (telemetryContext == null) continue;
                    telemetryContext.closeContext();
                }
            }
            return;
        }
        catch (InterruptedException exception) {
            LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.interruptedExceptionDuringMonitoring", new Object[]{this.hostSpec.getHost()}));
            return;
        }
        catch (Exception ex) {
            if (!LOGGER.isLoggable(Level.FINEST)) return;
            LOGGER.log(Level.FINEST, Messages.get("LimitlessRouterMonitor.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
            return;
        }
        finally {
            this.stopped.set(true);
            try {
                if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                    this.monitoringConn.close();
                }
            }
            catch (SQLException exception) {}
            this.monitoringConn = null;
        }
    }

    private void openConnection() throws SQLException {
        try {
            if (this.monitoringConn == null || this.monitoringConn.isClosed()) {
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.openingConnection", new Object[]{this.hostSpec.getUrl()}));
                this.monitoringConn = this.pluginService.forceConnect(this.hostSpec, this.props);
                LOGGER.finest(() -> Messages.get("LimitlessRouterMonitor.openedConnection", new Object[]{this.monitoringConn}));
            }
        }
        catch (SQLException ex) {
            if (this.monitoringConn != null && !this.monitoringConn.isClosed()) {
                try {
                    this.monitoringConn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.monitoringConn = null;
            }
            throw ex;
        }
    }
}

