/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider.monitoring;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitor;
import software.amazon.jdbc.util.CacheMap;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.SynchronousExecutor;
import software.amazon.jdbc.util.Utils;

public class ClusterTopologyMonitorImpl
implements ClusterTopologyMonitor {
    private static final Logger LOGGER = Logger.getLogger(ClusterTopologyMonitorImpl.class.getName());
    protected static final String MONITORING_PROPERTY_PREFIX = "topology-monitoring-";
    protected static final Executor networkTimeoutExecutor = new SynchronousExecutor();
    protected static final RdsUtils rdsHelper = new RdsUtils();
    protected static final int defaultTopologyQueryTimeoutMs = 1000;
    protected static final int closeConnectionNetworkTimeoutMs = 500;
    protected static final int defaultConnectionTimeoutMs = 5000;
    protected static final int defaultSocketTimeoutMs = 5000;
    protected static final long highRefreshPeriodAfterPanicNano = TimeUnit.SECONDS.toNanos(30L);
    protected static final long ignoreTopologyRequestNano = TimeUnit.SECONDS.toNanos(10L);
    protected final long refreshRateNano;
    protected final long highRefreshRateNano;
    protected final long topologyCacheExpirationNano;
    protected final Properties properties;
    protected final Properties monitoringProperties;
    protected final PluginService pluginService;
    protected final HostSpec initialHostSpec;
    protected final CacheMap<String, List<HostSpec>> topologyMap;
    protected final String topologyQuery;
    protected final String nodeIdQuery;
    protected final String writerTopologyQuery;
    protected final HostListProviderService hostListProviderService;
    protected final HostSpec clusterInstanceTemplate;
    protected String clusterId;
    protected final AtomicReference<HostSpec> writerHostSpec = new AtomicReference<Object>(null);
    protected final AtomicReference<Connection> monitoringConnection = new AtomicReference<Object>(null);
    protected boolean isVerifiedWriterConnection = false;
    protected final AtomicBoolean stop = new AtomicBoolean(false);
    protected long highRefreshRateEndTimeNano = 0L;
    protected final Object topologyUpdated = new Object();
    protected final AtomicBoolean requestToUpdateTopology = new AtomicBoolean(false);
    protected final AtomicLong ignoreNewTopologyRequestsEndTimeNano = new AtomicLong(-1L);
    protected final ConcurrentHashMap<String, Boolean> submittedNodes = new ConcurrentHashMap();
    protected ExecutorService nodeExecutorService = null;
    protected final ReentrantLock nodeExecutorLock = new ReentrantLock();
    protected final AtomicBoolean nodeThreadsStop = new AtomicBoolean(false);
    protected final AtomicReference<Connection> nodeThreadsWriterConnection = new AtomicReference<Object>(null);
    protected final AtomicReference<HostSpec> nodeThreadsWriterHostSpec = new AtomicReference<Object>(null);
    protected final AtomicReference<Connection> nodeThreadsReaderConnection = new AtomicReference<Object>(null);
    protected final AtomicReference<List<HostSpec>> nodeThreadsLatestTopology = new AtomicReference<Object>(null);
    protected final ExecutorService monitorExecutor = ExecutorFactory.newSingleThreadExecutor("monitor");

    public ClusterTopologyMonitorImpl(String clusterId, CacheMap<String, List<HostSpec>> topologyMap, HostSpec initialHostSpec, Properties properties, PluginService pluginService, HostListProviderService hostListProviderService, HostSpec clusterInstanceTemplate, long refreshRateNano, long highRefreshRateNano, long topologyCacheExpirationNano, String topologyQuery, String writerTopologyQuery, String nodeIdQuery) {
        this.clusterId = clusterId;
        this.topologyMap = topologyMap;
        this.initialHostSpec = initialHostSpec;
        this.pluginService = pluginService;
        this.hostListProviderService = hostListProviderService;
        this.clusterInstanceTemplate = clusterInstanceTemplate;
        this.properties = properties;
        this.refreshRateNano = refreshRateNano;
        this.highRefreshRateNano = highRefreshRateNano;
        this.topologyCacheExpirationNano = topologyCacheExpirationNano;
        this.topologyQuery = topologyQuery;
        this.writerTopologyQuery = writerTopologyQuery;
        this.nodeIdQuery = nodeIdQuery;
        this.monitoringProperties = PropertyUtils.copyProperties(properties);
        this.properties.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
            this.monitoringProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.properties.getProperty((String)p));
            this.monitoringProperties.remove(p);
        });
        if (PropertyDefinition.SOCKET_TIMEOUT.getString(this.monitoringProperties) == null) {
            PropertyDefinition.SOCKET_TIMEOUT.set(this.monitoringProperties, String.valueOf(5000));
        }
        if (PropertyDefinition.CONNECT_TIMEOUT.getString(this.monitoringProperties) == null) {
            PropertyDefinition.CONNECT_TIMEOUT.set(this.monitoringProperties, String.valueOf(5000));
        }
        this.monitorExecutor.submit(this);
        this.monitorExecutor.shutdown();
    }

    @Override
    public boolean canDispose() {
        return true;
    }

    @Override
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public List<HostSpec> forceRefresh(boolean shouldVerifyWriter, long timeoutMs) throws SQLException, TimeoutException {
        if (this.ignoreNewTopologyRequestsEndTimeNano.get() > 0L && System.nanoTime() < this.ignoreNewTopologyRequestsEndTimeNano.get()) {
            List<HostSpec> currentHosts = this.topologyMap.get(this.clusterId);
            LOGGER.finest(Utils.logTopology(currentHosts, Messages.get("ClusterTopologyMonitorImpl.ignoringTopologyRequest")));
            if (currentHosts != null) {
                return currentHosts;
            }
        }
        if (shouldVerifyWriter) {
            Connection monitoringConnection = this.monitoringConnection.get();
            this.monitoringConnection.set(null);
            this.isVerifiedWriterConnection = false;
            this.closeConnection(monitoringConnection, true);
        }
        return this.waitTillTopologyGetsUpdated(timeoutMs);
    }

    @Override
    public List<HostSpec> forceRefresh(@Nullable Connection connection, long timeoutMs) throws SQLException, TimeoutException {
        if (this.isVerifiedWriterConnection) {
            return this.waitTillTopologyGetsUpdated(timeoutMs);
        }
        return this.fetchTopologyAndUpdateCache(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<HostSpec> waitTillTopologyGetsUpdated(long timeoutMs) throws TimeoutException {
        List<HostSpec> latestHosts;
        List<HostSpec> currentHosts = this.topologyMap.get(this.clusterId);
        AtomicBoolean atomicBoolean = this.requestToUpdateTopology;
        synchronized (atomicBoolean) {
            this.requestToUpdateTopology.set(true);
            this.requestToUpdateTopology.notifyAll();
        }
        if (timeoutMs == 0L) {
            LOGGER.finest(Utils.logTopology(currentHosts, Messages.get("ClusterTopologyMonitorImpl.timeoutSetToZero")));
            return currentHosts;
        }
        long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        while (currentHosts == (latestHosts = this.topologyMap.get(this.clusterId)) && System.nanoTime() < end) {
            try {
                Object object = this.topologyUpdated;
                synchronized (object) {
                    this.topologyUpdated.wait(1000L);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.fine(Messages.get("ClusterTopologyMonitorImpl.interrupted"));
                Thread.currentThread().interrupt();
                return null;
            }
        }
        if (System.nanoTime() >= end) {
            throw new TimeoutException(Messages.get("ClusterTopologyMonitorImpl.topologyNotUpdated", new Object[]{timeoutMs}));
        }
        return latestHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.stop.set(true);
        this.nodeThreadsStop.set(true);
        this.shutdownNodeExecutorService();
        AtomicBoolean atomicBoolean = this.requestToUpdateTopology;
        synchronized (atomicBoolean) {
            this.requestToUpdateTopology.set(true);
            this.requestToUpdateTopology.notifyAll();
        }
        if (!this.monitorExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
            this.monitorExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOGGER.finest(() -> Messages.get("ClusterTopologyMonitorImpl.startMonitoringThread", new Object[]{this.initialHostSpec.getHost()}));
            while (!this.stop.get()) {
                List<HostSpec> hosts;
                if (this.isInPanicMode()) {
                    if (this.submittedNodes.isEmpty()) {
                        LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.startingNodeMonitoringThreads"));
                        this.nodeThreadsStop.set(false);
                        this.nodeThreadsWriterConnection.set(null);
                        this.nodeThreadsReaderConnection.set(null);
                        this.nodeThreadsWriterHostSpec.set(null);
                        this.nodeThreadsLatestTopology.set(null);
                        hosts = this.topologyMap.get(this.clusterId);
                        if (hosts == null) {
                            hosts = this.openAnyConnectionAndUpdateTopology();
                        }
                        this.shutdownNodeExecutorService();
                        this.createNodeExecutorService();
                        if (hosts != null && !this.isVerifiedWriterConnection) {
                            for (HostSpec hostSpec : hosts) {
                                this.submittedNodes.computeIfAbsent(hostSpec.getHost(), key -> {
                                    this.nodeExecutorService.submit(this.getNodeMonitoringWorker(hostSpec, this.writerHostSpec.get()));
                                    return true;
                                });
                            }
                        }
                    } else {
                        Connection writerConnection = this.nodeThreadsWriterConnection.get();
                        HostSpec writerConnectionHostSpec = this.nodeThreadsWriterHostSpec.get();
                        if (writerConnection != null && writerConnectionHostSpec != null) {
                            LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.writerPickedUpFromNodeMonitors", new Object[]{writerConnectionHostSpec}));
                            this.closeConnection(this.monitoringConnection.get());
                            this.monitoringConnection.set(writerConnection);
                            this.writerHostSpec.set(writerConnectionHostSpec);
                            this.isVerifiedWriterConnection = true;
                            this.highRefreshRateEndTimeNano = System.nanoTime() + highRefreshPeriodAfterPanicNano;
                            if (!this.ignoreNewTopologyRequestsEndTimeNano.compareAndSet(-1L, 0L)) {
                                this.ignoreNewTopologyRequestsEndTimeNano.set(System.nanoTime() + ignoreTopologyRequestNano);
                            }
                            this.nodeThreadsStop.set(true);
                            this.shutdownNodeExecutorService();
                            this.submittedNodes.clear();
                            continue;
                        }
                        List<HostSpec> hosts2 = this.nodeThreadsLatestTopology.get();
                        if (hosts2 != null && !this.nodeThreadsStop.get()) {
                            for (HostSpec hostSpec : hosts2) {
                                this.submittedNodes.computeIfAbsent(hostSpec.getHost(), key -> {
                                    this.nodeExecutorService.submit(this.getNodeMonitoringWorker(hostSpec, this.writerHostSpec.get()));
                                    return true;
                                });
                            }
                        }
                    }
                    this.delay(true);
                } else {
                    if (!this.submittedNodes.isEmpty()) {
                        this.shutdownNodeExecutorService();
                        this.submittedNodes.clear();
                    }
                    if ((hosts = this.fetchTopologyAndUpdateCache(this.monitoringConnection.get())) == null) {
                        Connection conn = this.monitoringConnection.get();
                        this.monitoringConnection.set(null);
                        this.isVerifiedWriterConnection = false;
                        this.closeConnection(conn);
                        continue;
                    }
                    if (this.highRefreshRateEndTimeNano > 0L && System.nanoTime() > this.highRefreshRateEndTimeNano) {
                        this.highRefreshRateEndTimeNano = 0L;
                    }
                    if (this.highRefreshRateEndTimeNano == 0L) {
                        LOGGER.finest(Utils.logTopology(this.topologyMap.get(this.clusterId)));
                    }
                    this.delay(false);
                }
                if (this.ignoreNewTopologyRequestsEndTimeNano.get() <= 0L || System.nanoTime() <= this.ignoreNewTopologyRequestsEndTimeNano.get()) continue;
                this.ignoreNewTopologyRequestsEndTimeNano.set(0L);
            }
        }
        catch (InterruptedException intEx) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, Messages.get("ClusterTopologyMonitorImpl.exceptionDuringMonitoringStop", new Object[]{this.initialHostSpec.getHost()}), ex);
            }
        }
        finally {
            this.stop.set(true);
            this.shutdownNodeExecutorService();
            Connection conn = this.monitoringConnection.get();
            this.monitoringConnection.set(null);
            this.closeConnection(conn);
            LOGGER.finest(() -> Messages.get("ClusterTopologyMonitorImpl.stopMonitoringThread", new Object[]{this.initialHostSpec.getHost()}));
        }
    }

    protected void shutdownNodeExecutorService() {
        if (this.nodeExecutorService != null) {
            this.nodeExecutorLock.lock();
            try {
                if (this.nodeExecutorService == null) {
                    return;
                }
                if (!this.nodeExecutorService.isShutdown()) {
                    this.nodeExecutorService.shutdown();
                }
                try {
                    if (!this.nodeExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.nodeExecutorService.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.nodeExecutorService = null;
            }
            finally {
                this.nodeExecutorLock.unlock();
            }
        }
    }

    protected void createNodeExecutorService() {
        this.nodeExecutorLock.lock();
        try {
            this.nodeExecutorService = ExecutorFactory.newCachedThreadPool("node");
        }
        finally {
            this.nodeExecutorLock.unlock();
        }
    }

    protected boolean isInPanicMode() {
        return this.monitoringConnection.get() == null || !this.isVerifiedWriterConnection;
    }

    protected Runnable getNodeMonitoringWorker(HostSpec hostSpec, @Nullable HostSpec writerHostSpec) {
        return new NodeMonitoringWorker(this, hostSpec, writerHostSpec);
    }

    protected List<HostSpec> openAnyConnectionAndUpdateTopology() {
        boolean writerVerifiedByThisThread;
        block12: {
            writerVerifiedByThisThread = false;
            if (this.monitoringConnection.get() == null) {
                Connection conn;
                try {
                    conn = this.pluginService.forceConnect(this.initialHostSpec, this.monitoringProperties);
                }
                catch (SQLException ex) {
                    return null;
                }
                if (this.monitoringConnection.compareAndSet(null, conn)) {
                    LOGGER.finest(() -> Messages.get("ClusterTopologyMonitorImpl.openedMonitoringConnection", new Object[]{this.initialHostSpec.getHost()}));
                    try {
                        if (StringUtils.isNullOrEmpty(this.getWriterNodeId(this.monitoringConnection.get()))) break block12;
                        this.isVerifiedWriterConnection = true;
                        writerVerifiedByThisThread = true;
                        if (rdsHelper.isRdsInstance(this.initialHostSpec.getHost())) {
                            this.writerHostSpec.set(this.initialHostSpec);
                            LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.writerMonitoringConnection", new Object[]{this.writerHostSpec.get().getHost()}));
                        } else {
                            String nodeId = this.getNodeId(this.monitoringConnection.get());
                            if (!StringUtils.isNullOrEmpty(nodeId)) {
                                this.writerHostSpec.set(this.createHost(nodeId, true, 0L, null));
                                LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.writerMonitoringConnection", new Object[]{this.writerHostSpec.get().getHost()}));
                            }
                        }
                    }
                    catch (SQLException nodeId) {}
                } else {
                    this.closeConnection(conn);
                }
            }
        }
        List<HostSpec> hosts = this.fetchTopologyAndUpdateCache(this.monitoringConnection.get());
        if (writerVerifiedByThisThread && !this.ignoreNewTopologyRequestsEndTimeNano.compareAndSet(-1L, 0L)) {
            this.ignoreNewTopologyRequestsEndTimeNano.set(System.nanoTime() + ignoreTopologyRequestNano);
        }
        if (hosts == null) {
            Connection connToClose = this.monitoringConnection.get();
            this.monitoringConnection.set(null);
            this.closeConnection(connToClose);
            this.isVerifiedWriterConnection = false;
        }
        return hosts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getNodeId(Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(this.nodeIdQuery);){
            if (!resultSet.next()) return null;
            String string = resultSet.getString(1);
            return string;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    protected void closeConnection(@Nullable Connection connection) {
        this.closeConnection(connection, true);
    }

    protected void closeConnection(@Nullable Connection connection, boolean unstableConnection) {
        block5: {
            try {
                if (connection == null || connection.isClosed()) break block5;
                if (unstableConnection) {
                    try {
                        connection.setNetworkTimeout(networkTimeoutExecutor, 500);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(boolean useHighRefreshRate) throws InterruptedException {
        if (this.highRefreshRateEndTimeNano > 0L && System.nanoTime() < this.highRefreshRateEndTimeNano) {
            useHighRefreshRate = true;
        }
        if (this.requestToUpdateTopology.get()) {
            useHighRefreshRate = true;
        }
        long start = System.nanoTime();
        long end = start + (useHighRefreshRate ? this.highRefreshRateNano : this.refreshRateNano);
        do {
            AtomicBoolean atomicBoolean = this.requestToUpdateTopology;
            synchronized (atomicBoolean) {
                this.requestToUpdateTopology.wait(50L);
            }
        } while (!this.requestToUpdateTopology.get() && System.nanoTime() < end && !this.stop.get());
    }

    protected @Nullable List<HostSpec> fetchTopologyAndUpdateCache(Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            List<HostSpec> hosts = this.queryForTopology(connection);
            if (!Utils.isNullOrEmpty(hosts)) {
                this.updateTopologyCache(hosts);
            }
            return hosts;
        }
        catch (SQLException ex) {
            LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.errorFetchingTopology", new Object[]{ex}));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTopologyCache(@NonNull List<HostSpec> hosts) {
        AtomicBoolean atomicBoolean = this.requestToUpdateTopology;
        synchronized (atomicBoolean) {
            this.topologyMap.put(this.clusterId, hosts, this.topologyCacheExpirationNano);
            Object object = this.topologyUpdated;
            synchronized (object) {
                this.requestToUpdateTopology.set(false);
                this.topologyUpdated.notifyAll();
            }
        }
    }

    protected String getWriterNodeId(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(this.writerTopologyQuery);){
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected @Nullable List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getSuggestedWriterNodeId(Connection connection) throws SQLException {
        return null;
    }

    protected @Nullable List<HostSpec> processQueryResults(ResultSet resultSet, String suggestedWriterNodeId) throws SQLException {
        HashMap<String, HostSpec> hostMap = new HashMap<String, HostSpec>();
        if (resultSet.getMetaData().getColumnCount() == 0) {
            LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.unexpectedTopologyQueryColumnCount"));
            return null;
        }
        while (resultSet.next()) {
            try {
                HostSpec host = this.createHost(resultSet, suggestedWriterNodeId);
                hostMap.put(host.getHost(), host);
            }
            catch (Exception e) {
                LOGGER.finest(Messages.get("ClusterTopologyMonitorImpl.errorProcessingQueryResults", new Object[]{e.getMessage()}));
                return null;
            }
        }
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        ArrayList<HostSpec> writers = new ArrayList<HostSpec>();
        for (HostSpec host : hostMap.values()) {
            if (host.getRole() != HostRole.WRITER) {
                hosts.add(host);
                continue;
            }
            writers.add(host);
        }
        int writerCount = writers.size();
        if (writerCount == 0) {
            LOGGER.warning(() -> Messages.get("ClusterTopologyMonitorImpl.invalidTopology"));
            hosts.clear();
        } else if (writerCount == 1) {
            hosts.add((HostSpec)writers.get(0));
        } else {
            List sortedWriters = writers.stream().sorted(Comparator.comparing(HostSpec::getLastUpdateTime, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
            hosts.add((HostSpec)sortedWriters.get(0));
        }
        return hosts;
    }

    protected HostSpec createHost(ResultSet resultSet, String suggestedWriterNodeId) throws SQLException {
        Timestamp lastUpdateTime;
        String hostName = resultSet.getString(1);
        boolean isWriter = resultSet.getBoolean(2);
        float cpuUtilization = resultSet.getFloat(3);
        float nodeLag = resultSet.getFloat(4);
        try {
            lastUpdateTime = resultSet.getTimestamp(5);
        }
        catch (Exception e) {
            lastUpdateTime = Timestamp.from(Instant.now());
        }
        long weight = (long)Math.round(nodeLag) * 100L + (long)Math.round(cpuUtilization);
        return this.createHost(hostName, isWriter, weight, lastUpdateTime);
    }

    protected HostSpec createHost(String nodeName, boolean isWriter, long weight, Timestamp lastUpdateTime) {
        nodeName = nodeName == null ? "?" : nodeName;
        String endpoint = this.getHostEndpoint(nodeName);
        int port = this.clusterInstanceTemplate.isPortSpecified() ? this.clusterInstanceTemplate.getPort() : this.initialHostSpec.getPort();
        HostSpec hostSpec = this.hostListProviderService.getHostSpecBuilder().host(endpoint).port(port).role(isWriter ? HostRole.WRITER : HostRole.READER).availability(HostAvailability.AVAILABLE).weight(weight).lastUpdateTime(lastUpdateTime).build();
        hostSpec.addAlias(nodeName);
        hostSpec.setHostId(nodeName);
        return hostSpec;
    }

    protected String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    private static /* synthetic */ String lambda$queryForTopology$7(SQLException e) {
        return Messages.get("ClusterTopologyMonitorImpl.errorGettingNetworkTimeout", new Object[]{e.getMessage()});
    }

    private static class NodeMonitoringWorker
    implements Runnable {
        private static final Logger LOGGER = Logger.getLogger(NodeMonitoringWorker.class.getName());
        protected final ClusterTopologyMonitorImpl monitor;
        protected final HostSpec hostSpec;
        protected final @Nullable HostSpec writerHostSpec;
        protected boolean writerChanged = false;

        public NodeMonitoringWorker(ClusterTopologyMonitorImpl monitor, HostSpec hostSpec, @Nullable HostSpec writerHostSpec) {
            this.monitor = monitor;
            this.hostSpec = hostSpec;
            this.writerHostSpec = writerHostSpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long start;
            Connection connection;
            block22: {
                block21: {
                    connection = null;
                    boolean updateTopology = false;
                    start = System.nanoTime();
                    try {
                        while (!this.monitor.nodeThreadsStop.get()) {
                            if (connection == null) {
                                try {
                                    connection = this.monitor.pluginService.forceConnect(this.hostSpec, this.monitor.monitoringProperties);
                                    this.monitor.pluginService.setAvailability(this.hostSpec.asAliases(), HostAvailability.AVAILABLE);
                                }
                                catch (SQLException ex) {
                                    this.monitor.pluginService.setAvailability(this.hostSpec.asAliases(), HostAvailability.NOT_AVAILABLE);
                                }
                            }
                            if (connection != null) {
                                String writerId = null;
                                try {
                                    writerId = this.monitor.getWriterNodeId(connection);
                                }
                                catch (SQLSyntaxErrorException ex) {
                                    LOGGER.severe(() -> Messages.get("NodeMonitoringThread.invalidWriterQuery", new Object[]{ex.getMessage()}));
                                    throw new RuntimeException(ex);
                                }
                                catch (SQLException ex) {
                                    this.monitor.closeConnection(connection);
                                    connection = null;
                                }
                                if (!StringUtils.isNullOrEmpty(writerId)) {
                                    if (!this.monitor.nodeThreadsWriterConnection.compareAndSet(null, connection)) {
                                        this.monitor.closeConnection(connection);
                                    } else {
                                        LOGGER.fine(Messages.get("NodeMonitoringThread.detectedWriter", new Object[]{writerId}));
                                        this.monitor.fetchTopologyAndUpdateCache(connection);
                                        this.monitor.nodeThreadsWriterHostSpec.set(this.hostSpec);
                                        this.monitor.nodeThreadsStop.set(true);
                                        LOGGER.fine(Utils.logTopology(this.monitor.topologyMap.get(this.monitor.clusterId)));
                                    }
                                    connection = null;
                                    this.monitor.closeConnection(connection);
                                    break block21;
                                }
                                if (connection != null && this.monitor.nodeThreadsWriterConnection.get() == null) {
                                    if (updateTopology) {
                                        this.readerThreadFetchTopology(connection, this.writerHostSpec);
                                    } else if (this.monitor.nodeThreadsReaderConnection.get() == null && this.monitor.nodeThreadsReaderConnection.compareAndSet(null, connection)) {
                                        updateTopology = true;
                                        this.readerThreadFetchTopology(connection, this.writerHostSpec);
                                    }
                                }
                            }
                            TimeUnit.MILLISECONDS.sleep(100L);
                        }
                        this.monitor.closeConnection(connection);
                        break block22;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                long end = System.nanoTime();
                LOGGER.finest(() -> Messages.get("NodeMonitoringThread.threadCompleted", new Object[]{TimeUnit.NANOSECONDS.toMillis(end - start)}));
                return;
            }
            long end = System.nanoTime();
            LOGGER.finest(() -> Messages.get("NodeMonitoringThread.threadCompleted", new Object[]{TimeUnit.NANOSECONDS.toMillis(end - start)}));
            return;
            finally {
                this.monitor.closeConnection(connection);
                end = System.nanoTime();
                LOGGER.finest(() -> Messages.get("NodeMonitoringThread.threadCompleted", new Object[]{TimeUnit.NANOSECONDS.toMillis(end - start)}));
            }
        }

        private void readerThreadFetchTopology(Connection connection, @Nullable HostSpec writerHostSpec) {
            List<HostSpec> hosts;
            if (connection == null) {
                return;
            }
            try {
                hosts = this.monitor.queryForTopology(connection);
                if (hosts == null) {
                    return;
                }
            }
            catch (SQLException ex) {
                return;
            }
            this.monitor.nodeThreadsLatestTopology.set(hosts);
            if (this.writerChanged) {
                this.monitor.updateTopologyCache(hosts);
                LOGGER.finest(Utils.logTopology(hosts));
                return;
            }
            HostSpec latestWriterHostSpec = hosts.stream().filter(x -> x.getRole() == HostRole.WRITER).findFirst().orElse(null);
            if (latestWriterHostSpec != null && writerHostSpec != null && !latestWriterHostSpec.getHostAndPort().equals(writerHostSpec.getHostAndPort())) {
                this.writerChanged = true;
                LOGGER.fine(() -> Messages.get("NodeMonitoringThread.writerNodeChanged", new Object[]{writerHostSpec.getHost(), latestWriterHostSpec.getHost()}));
                this.monitor.updateTopologyCache(hosts);
                LOGGER.fine(Utils.logTopology(hosts));
            }
        }
    }
}

