/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import com.mysql.cj.exceptions.CJException;
import java.sql.SQLException;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;

public class MySQLExceptionHandler
implements ExceptionHandler {
    public static final String SQLSTATE_ACCESS_ERROR = "28000";
    public static final String SQLSTATE_SYNTAX_ERROR_OR_ACCESS_VIOLATION = "42000";
    public static final String SET_NETWORK_TIMEOUT_ON_CLOSED_CONNECTION = "setNetworkTimeout cannot be called on a closed connection";

    @Override
    public boolean isNetworkException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLException) {
                SQLException sqlException = (SQLException)exception;
                if (!this.isNetworkException(sqlException.getSQLState()) && !this.isHikariMariaDbNetworkException(sqlException)) continue;
                return true;
            }
            if (!(exception instanceof CJException)) continue;
            return this.isNetworkException(((CJException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return sqlState.startsWith("08");
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            String sqlState = null;
            if (exception instanceof SQLException) {
                sqlState = ((SQLException)exception).getSQLState();
            } else if (exception instanceof CJException) {
                sqlState = ((CJException)exception).getSQLState();
            }
            if (!this.isLoginException(sqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return SQLSTATE_ACCESS_ERROR.equals(sqlState);
    }

    private boolean isHikariMariaDbNetworkException(SQLException sqlException) {
        return sqlException.getSQLState().equals(SQLSTATE_SYNTAX_ERROR_OR_ACCESS_VIOLATION) && sqlException.getMessage().contains(SET_NETWORK_TIMEOUT_ON_CLOSED_CONNECTION);
    }
}

