/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Logger;
import software.amazon.jdbc.ConnectionPluginChainBuilder;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.dialect.PgDialect;
import software.amazon.jdbc.hostlistprovider.AuroraHostListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.MonitoringRdsHostListProvider;

public class AuroraPgDialect
extends PgDialect {
    private static final Logger LOGGER = Logger.getLogger(AuroraPgDialect.class.getName());
    private static final String extensionsSql = "SELECT (setting LIKE '%aurora_stat_utils%') AS aurora_stat_utils FROM pg_settings WHERE name='rds.extensions'";
    private static final String topologySql = "SELECT 1 FROM aurora_replica_status() LIMIT 1";
    private static final String TOPOLOGY_QUERY = "SELECT SERVER_ID, CASE WHEN SESSION_ID = 'MASTER_SESSION_ID' THEN TRUE ELSE FALSE END, CPU, COALESCE(REPLICA_LAG_IN_MSEC, 0), LAST_UPDATE_TIMESTAMP FROM aurora_replica_status() WHERE EXTRACT(EPOCH FROM(NOW() - LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' OR LAST_UPDATE_TIMESTAMP IS NULL";
    private static final String IS_WRITER_QUERY = "SELECT SERVER_ID FROM aurora_replica_status() WHERE SESSION_ID = 'MASTER_SESSION_ID' AND SERVER_ID = aurora_db_instance_identifier()";
    private static final String NODE_ID_QUERY = "SELECT aurora_db_instance_identifier()";
    private static final String IS_READER_QUERY = "SELECT pg_is_in_recovery()";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        if (!super.isDialect(connection)) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        boolean hasExtensions = false;
        boolean hasTopology = false;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(extensionsSql);
            if (rs.next()) {
                boolean auroraUtils = rs.getBoolean("aurora_stat_utils");
                LOGGER.finest(() -> String.format("auroraUtils: %b", auroraUtils));
                if (auroraUtils) {
                    hasExtensions = true;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (!hasExtensions) {
            return false;
        }
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(topologySql);
            if (rs.next()) {
                LOGGER.finest(() -> "hasTopology: true");
                hasTopology = true;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hasExtensions && hasTopology;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, hostListProviderService, pluginService) -> {
            List<String> plugins = ConnectionPluginChainBuilder.getPluginCodes(properties);
            if (plugins.contains("failover2")) {
                return new MonitoringRdsHostListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY, IS_WRITER_QUERY, pluginService);
            }
            return new AuroraHostListProvider(properties, initialUrl, hostListProviderService, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY);
        };
    }
}

