/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import com.mysql.cj.exceptions.CJException;
import java.sql.SQLException;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;

public class MySQLExceptionHandler
implements ExceptionHandler {
    public static final String SQLSTATE_ACCESS_ERROR = "28000";

    @Override
    public boolean isNetworkException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLException) {
                return this.isNetworkException(((SQLException)exception).getSQLState());
            }
            if (!(exception instanceof CJException)) continue;
            return this.isNetworkException(((CJException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return sqlState.startsWith("08");
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            if (exception instanceof SQLException) {
                return this.isLoginException(((SQLException)exception).getSQLState());
            }
            if (!(exception instanceof CJException)) continue;
            return this.isLoginException(((CJException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return SQLSTATE_ACCESS_ERROR.equals(sqlState);
    }
}

