/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.DriverConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.TargetDriverHelper;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.profile.DriverConfigurationProfiles;
import software.amazon.jdbc.states.ResetSessionStateOnCloseCallable;
import software.amazon.jdbc.states.TransferSessionStateOnSwitchCallable;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialectManager;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.DefaultTelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class Driver
implements java.sql.Driver {
    private static final String PROTOCOL_PREFIX = "jdbc:aws-wrapper:";
    private static final Logger PARENT_LOGGER = Logger.getLogger("software.amazon.jdbc");
    private static final Logger LOGGER = Logger.getLogger("software.amazon.jdbc.Driver");
    private static @Nullable Driver registeredDriver;
    private static ResetSessionStateOnCloseCallable resetSessionStateOnCloseCallable;
    private static TransferSessionStateOnSwitchCallable transferSessionStateOnSwitchCallable;

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException(Messages.get("Driver.alreadyRegistered"));
        }
        Driver driver = new Driver();
        DriverManager.registerDriver(driver);
        registeredDriver = driver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException(Messages.get("Driver.notRegistered"));
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        if (registeredDriver != null) {
            ArrayList<java.sql.Driver> registeredDrivers = Collections.list(DriverManager.getDrivers());
            for (java.sql.Driver d : registeredDrivers) {
                if (d != registeredDriver) continue;
                return true;
            }
            registeredDriver = null;
        }
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        LOGGER.finest("Opening connection to " + url);
        ConnectionUrlParser.parsePropertiesFromUrl(url, info);
        Properties props = PropertyUtils.copyProperties(info);
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(url);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(props, databaseName);
        }
        LOGGER.finest(() -> PropertyUtils.logProperties(PropertyUtils.maskProperties(props), "Connecting with properties: \n"));
        String profileName = PropertyDefinition.PROFILE_NAME.getString(props);
        ConfigurationProfile configurationProfile = null;
        if (!StringUtils.isNullOrEmpty(profileName)) {
            configurationProfile = DriverConfigurationProfiles.getProfileConfiguration(profileName);
            if (configurationProfile != null) {
                PropertyUtils.addProperties(props, configurationProfile.getProperties());
            } else {
                throw new SQLException(Messages.get("Driver.configurationProfileNotFound", new Object[]{profileName}));
            }
        }
        DefaultTelemetryFactory telemetryFactory = new DefaultTelemetryFactory(props);
        TelemetryContext context = telemetryFactory.openTelemetryContext("software.amazon.jdbc.Driver.connect", TelemetryTraceLevel.TOP_LEVEL);
        try {
            TargetDriverDialect targetDriverDialect;
            String driverUrl = url.replaceFirst(PROTOCOL_PREFIX, "jdbc:");
            TargetDriverHelper helper = new TargetDriverHelper();
            java.sql.Driver driver = helper.getTargetDriver(driverUrl, props);
            String logLevelStr = PropertyDefinition.LOGGER_LEVEL.getString(props);
            if (!StringUtils.isNullOrEmpty(logLevelStr)) {
                Level logLevel = Level.parse(logLevelStr.toUpperCase());
                Logger rootLogger = Logger.getLogger("");
                for (Handler handler : rootLogger.getHandlers()) {
                    if (!(handler instanceof ConsoleHandler) || handler.getLevel().intValue() <= logLevel.intValue()) continue;
                    handler.setLevel(logLevel);
                }
                PARENT_LOGGER.setLevel(logLevel);
            }
            TargetDriverDialect targetDriverDialect2 = targetDriverDialect = configurationProfile == null ? null : configurationProfile.getTargetDriverDialect();
            if (targetDriverDialect == null) {
                TargetDriverDialectManager targetDriverDialectManager = new TargetDriverDialectManager();
                targetDriverDialect = targetDriverDialectManager.getDialect(driver, props);
            }
            DriverConnectionProvider defaultConnectionProvider = new DriverConnectionProvider(driver);
            ConnectionProvider effectiveConnectionProvider = null;
            if (configurationProfile != null) {
                effectiveConnectionProvider = configurationProfile.getConnectionProvider();
            }
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(props, driverUrl, defaultConnectionProvider, effectiveConnectionProvider, targetDriverDialect, configurationProfile, telemetryFactory);
            return connectionWrapper;
        }
        catch (Exception ex) {
            context.setException(ex);
            context.setSuccess(false);
            throw ex;
        }
        finally {
            context.closeContext();
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException(Messages.get("Driver.nullUrl"));
        }
        return url.startsWith(PROTOCOL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties copy = new Properties(info);
        String databaseName = ConnectionUrlParser.parseDatabaseFromUrl(url);
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            PropertyDefinition.DATABASE.set(copy, databaseName);
        }
        ConnectionUrlParser.parsePropertiesFromUrl(url, copy);
        Collection<AwsWrapperProperty> knownProperties = PropertyDefinition.allProperties();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.size()];
        int i = 0;
        for (AwsWrapperProperty prop : knownProperties) {
            props[i++] = prop.toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return PARENT_LOGGER;
    }

    public static void setResetSessionStateOnCloseFunc(@NonNull ResetSessionStateOnCloseCallable func) {
        resetSessionStateOnCloseCallable = func;
    }

    public static void resetResetSessionStateOnCloseFunc() {
        resetSessionStateOnCloseCallable = null;
    }

    public static ResetSessionStateOnCloseCallable getResetSessionStateOnCloseFunc() {
        return resetSessionStateOnCloseCallable;
    }

    public static void setTransferSessionStateOnSwitchFunc(@NonNull TransferSessionStateOnSwitchCallable func) {
        transferSessionStateOnSwitchCallable = func;
    }

    public static void resetTransferSessionStateOnSwitchFunc() {
        transferSessionStateOnSwitchCallable = null;
    }

    public static TransferSessionStateOnSwitchCallable getTransferSessionStateOnSwitchFunc() {
        return transferSessionStateOnSwitchCallable;
    }

    static {
        resetSessionStateOnCloseCallable = null;
        transferSessionStateOnSwitchCallable = null;
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

