/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.states;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.Driver;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.states.ResetSessionStateOnCloseCallable;
import software.amazon.jdbc.states.SessionState;
import software.amazon.jdbc.states.SessionStateService;
import software.amazon.jdbc.states.TransferSessionStateOnSwitchCallable;

public class SessionStateServiceImpl
implements SessionStateService {
    private static final Logger LOGGER = Logger.getLogger(SessionStateServiceImpl.class.getName());
    protected SessionState sessionState = new SessionState();
    protected SessionState copySessionState = null;
    protected final PluginService pluginService;
    protected final Properties props;

    public SessionStateServiceImpl(@NonNull PluginService pluginService, @NonNull Properties props) {
        this.pluginService = pluginService;
        this.props = props;
    }

    protected boolean transferStateEnabledSetting() {
        return PropertyDefinition.TRANSFER_SESSION_STATE_ON_SWITCH.getBoolean(this.props);
    }

    protected boolean resetStateEnabledSetting() {
        return PropertyDefinition.RESET_SESSION_STATE_ON_CLOSE.getBoolean(this.props);
    }

    @Override
    public Optional<Boolean> getAutoCommit() throws SQLException {
        return this.sessionState.autoCommit.getValue();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.autoCommit.setValue(autoCommit);
        this.logCurrentState();
    }

    @Override
    public void setupPristineAutoCommit() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.autoCommit.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.autoCommit.setPristineValue(this.pluginService.getCurrentConnection().getAutoCommit());
        this.logCurrentState();
    }

    @Override
    public void setupPristineAutoCommit(boolean autoCommit) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.autoCommit.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.autoCommit.setPristineValue(autoCommit);
        this.logCurrentState();
    }

    @Override
    public Optional<Boolean> getReadOnly() throws SQLException {
        return this.sessionState.readOnly.getValue();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.readOnly.setValue(readOnly);
        this.logCurrentState();
    }

    @Override
    public void setupPristineReadOnly() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.readOnly.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.readOnly.setPristineValue(this.pluginService.getCurrentConnection().isReadOnly());
        this.logCurrentState();
    }

    @Override
    public void setupPristineReadOnly(boolean readOnly) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.readOnly.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.readOnly.setPristineValue(readOnly);
        this.logCurrentState();
    }

    @Override
    public Optional<String> getCatalog() throws SQLException {
        return this.sessionState.catalog.getValue();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.catalog.setValue(catalog);
        this.logCurrentState();
    }

    @Override
    public void setupPristineCatalog() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.catalog.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.catalog.setPristineValue(this.pluginService.getCurrentConnection().getCatalog());
        this.logCurrentState();
    }

    @Override
    public void setupPristineCatalog(String catalog) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.catalog.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.catalog.setPristineValue(catalog);
        this.logCurrentState();
    }

    @Override
    public Optional<Integer> getHoldability() throws SQLException {
        return this.sessionState.holdability.getValue();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.holdability.setValue(holdability);
        this.logCurrentState();
    }

    @Override
    public void setupPristineHoldability() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.holdability.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.holdability.setPristineValue(this.pluginService.getCurrentConnection().getHoldability());
        this.logCurrentState();
    }

    @Override
    public void setupPristineHoldability(int holdability) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.holdability.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.holdability.setPristineValue(holdability);
        this.logCurrentState();
    }

    @Override
    public Optional<Integer> getNetworkTimeout() throws SQLException {
        return this.sessionState.networkTimeout.getValue();
    }

    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.networkTimeout.setValue(milliseconds);
        this.logCurrentState();
    }

    @Override
    public void setupPristineNetworkTimeout() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.networkTimeout.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.networkTimeout.setPristineValue(this.pluginService.getCurrentConnection().getNetworkTimeout());
        this.logCurrentState();
    }

    @Override
    public void setupPristineNetworkTimeout(int milliseconds) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.networkTimeout.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.networkTimeout.setPristineValue(milliseconds);
        this.logCurrentState();
    }

    @Override
    public Optional<String> getSchema() throws SQLException {
        return this.sessionState.schema.getValue();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.schema.setValue(schema);
        this.logCurrentState();
    }

    @Override
    public void setupPristineSchema() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.schema.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.schema.setPristineValue(this.pluginService.getCurrentConnection().getSchema());
        this.logCurrentState();
    }

    @Override
    public void setupPristineSchema(String schema) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.schema.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.schema.setPristineValue(schema);
        this.logCurrentState();
    }

    @Override
    public Optional<Integer> getTransactionIsolation() throws SQLException {
        return this.sessionState.transactionIsolation.getValue();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.transactionIsolation.setValue(level);
        this.logCurrentState();
    }

    @Override
    public void setupPristineTransactionIsolation() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.transactionIsolation.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.transactionIsolation.setPristineValue(this.pluginService.getCurrentConnection().getTransactionIsolation());
        this.logCurrentState();
    }

    @Override
    public void setupPristineTransactionIsolation(int level) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.transactionIsolation.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.transactionIsolation.setPristineValue(level);
        this.logCurrentState();
    }

    @Override
    public Optional<Map<String, Class<?>>> getTypeMap() throws SQLException {
        return this.sessionState.typeMap.getValue();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        this.sessionState.typeMap.setValue(map);
        this.logCurrentState();
    }

    @Override
    public void setupPristineTypeMap() throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.typeMap.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.typeMap.setPristineValue(this.pluginService.getCurrentConnection().getTypeMap());
        this.logCurrentState();
    }

    @Override
    public void setupPristineTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        if (this.sessionState.typeMap.getPristineValue().isPresent()) {
            return;
        }
        this.sessionState.typeMap.setPristineValue(map);
        this.logCurrentState();
    }

    @Override
    public void reset() {
        this.sessionState.autoCommit.reset();
        this.sessionState.readOnly.reset();
        this.sessionState.catalog.reset();
        this.sessionState.schema.reset();
        this.sessionState.holdability.reset();
        this.sessionState.networkTimeout.reset();
        this.sessionState.transactionIsolation.reset();
        this.sessionState.typeMap.reset();
    }

    @Override
    public void begin() throws SQLException {
        this.logCurrentState();
        if (!this.transferStateEnabledSetting() && !this.resetStateEnabledSetting()) {
            return;
        }
        if (this.copySessionState != null) {
            throw new SQLException("Previous session state transfer is not completed.");
        }
        this.copySessionState = this.sessionState.copy();
    }

    @Override
    public void complete() {
        this.copySessionState = null;
    }

    @Override
    public void applyCurrentSessionState(Connection newConnection) throws SQLException {
        boolean isHandled;
        if (!this.transferStateEnabledSetting()) {
            return;
        }
        TransferSessionStateOnSwitchCallable callableCopy = Driver.getTransferSessionStateOnSwitchFunc();
        if (callableCopy != null && (isHandled = callableCopy.apply(this.sessionState, newConnection))) {
            return;
        }
        if (this.sessionState.autoCommit.getValue().isPresent()) {
            this.sessionState.autoCommit.resetPristineValue();
            this.setupPristineAutoCommit();
            newConnection.setAutoCommit(this.sessionState.autoCommit.getValue().get());
        }
        if (this.sessionState.readOnly.getValue().isPresent()) {
            this.sessionState.readOnly.resetPristineValue();
            this.setupPristineReadOnly();
            newConnection.setReadOnly(this.sessionState.readOnly.getValue().get());
        }
        if (this.sessionState.catalog.getValue().isPresent()) {
            this.sessionState.catalog.resetPristineValue();
            this.setupPristineCatalog();
            newConnection.setCatalog(this.sessionState.catalog.getValue().get());
        }
        if (this.sessionState.schema.getValue().isPresent()) {
            this.sessionState.schema.resetPristineValue();
            this.setupPristineSchema();
            newConnection.setSchema(this.sessionState.schema.getValue().get());
        }
        if (this.sessionState.holdability.getValue().isPresent()) {
            this.sessionState.holdability.resetPristineValue();
            this.setupPristineHoldability();
            newConnection.setHoldability(this.sessionState.holdability.getValue().get());
        }
        if (this.sessionState.transactionIsolation.getValue().isPresent()) {
            this.sessionState.transactionIsolation.resetPristineValue();
            this.setupPristineTransactionIsolation();
            newConnection.setTransactionIsolation(this.sessionState.transactionIsolation.getValue().get());
        }
        if (this.sessionState.networkTimeout.getValue().isPresent()) {
            this.sessionState.networkTimeout.resetPristineValue();
            this.setupPristineNetworkTimeout();
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            newConnection.setNetworkTimeout(executorService, this.sessionState.networkTimeout.getValue().get());
            executorService.shutdown();
        }
        if (this.sessionState.typeMap.getValue().isPresent()) {
            this.sessionState.typeMap.resetPristineValue();
            this.setupPristineTypeMap();
            newConnection.setTypeMap(this.sessionState.typeMap.getValue().get());
        }
    }

    @Override
    public void applyPristineSessionState(Connection connection) throws SQLException {
        boolean isHandled2;
        if (!this.resetStateEnabledSetting()) {
            return;
        }
        ResetSessionStateOnCloseCallable callableCopy = Driver.getResetSessionStateOnCloseFunc();
        if (callableCopy != null && (isHandled2 = callableCopy.apply(this.sessionState, connection))) {
            return;
        }
        if (this.copySessionState.autoCommit.canRestorePristine()) {
            try {
                connection.setAutoCommit(this.copySessionState.autoCommit.getPristineValue().get());
            }
            catch (SQLException isHandled2) {
                // empty catch block
            }
        }
        if (this.copySessionState.readOnly.canRestorePristine()) {
            try {
                connection.setReadOnly(this.copySessionState.readOnly.getPristineValue().get());
            }
            catch (SQLException isHandled2) {
                // empty catch block
            }
        }
        if (this.copySessionState.catalog.canRestorePristine()) {
            try {
                connection.setCatalog(this.copySessionState.catalog.getPristineValue().get());
            }
            catch (SQLException isHandled2) {
                // empty catch block
            }
        }
        if (this.copySessionState.schema.canRestorePristine()) {
            try {
                connection.setSchema(this.copySessionState.schema.getPristineValue().get());
            }
            catch (SQLException isHandled2) {
                // empty catch block
            }
        }
        if (this.copySessionState.holdability.canRestorePristine()) {
            try {
                connection.setHoldability(this.copySessionState.holdability.getPristineValue().get());
            }
            catch (SQLException isHandled2) {
                // empty catch block
            }
        }
        if (this.copySessionState.transactionIsolation.canRestorePristine()) {
            try {
                connection.setTransactionIsolation(this.copySessionState.transactionIsolation.getPristineValue().get());
            }
            catch (SQLException isHandled2) {
                // empty catch block
            }
        }
        if (this.copySessionState.networkTimeout.canRestorePristine()) {
            try {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                connection.setNetworkTimeout(executorService, this.copySessionState.networkTimeout.getPristineValue().get());
                executorService.shutdown();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.copySessionState.typeMap.canRestorePristine()) {
            try {
                connection.setTypeMap(this.copySessionState.typeMap.getPristineValue().get());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void logCurrentState() {
        LOGGER.finest(() -> "Current session state:\n" + this.sessionState);
    }
}

