/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Timestamp;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostavailability.HostAvailabilityStrategy;

public class HostSpecBuilder {
    private String host;
    private String hostId;
    private int port = -1;
    private HostAvailability availability = HostAvailability.AVAILABLE;
    private HostRole role = HostRole.WRITER;
    private long weight = 100L;
    private Timestamp lastUpdateTime;
    private HostAvailabilityStrategy hostAvailabilityStrategy;

    public HostSpecBuilder(@NonNull HostAvailabilityStrategy hostAvailabilityStrategy) {
        this.hostAvailabilityStrategy = hostAvailabilityStrategy;
    }

    public HostSpecBuilder(HostSpecBuilder hostSpecBuilder) {
        this.host = hostSpecBuilder.host;
        this.port = hostSpecBuilder.port;
        this.hostId = hostSpecBuilder.hostId;
        this.availability = hostSpecBuilder.availability;
        this.role = hostSpecBuilder.role;
        this.weight = hostSpecBuilder.weight;
        this.lastUpdateTime = hostSpecBuilder.lastUpdateTime;
        this.hostAvailabilityStrategy = hostSpecBuilder.hostAvailabilityStrategy;
    }

    public HostSpecBuilder host(String host) {
        this.host = host;
        return this;
    }

    public HostSpecBuilder port(int port) {
        this.port = port;
        return this;
    }

    public HostSpecBuilder hostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    public HostSpecBuilder availability(HostAvailability availability) {
        this.availability = availability;
        return this;
    }

    public HostSpecBuilder role(HostRole role) {
        this.role = role;
        return this;
    }

    public HostSpecBuilder weight(long weight) {
        this.weight = weight;
        return this;
    }

    public HostSpecBuilder hostAvailabilityStrategy(HostAvailabilityStrategy hostAvailabilityStrategy) {
        this.hostAvailabilityStrategy = hostAvailabilityStrategy;
        return this;
    }

    public HostSpecBuilder lastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public HostSpec build() {
        this.checkHostIsSet();
        return new HostSpec(this.host, this.port, this.hostId, this.role, this.availability, this.weight, this.lastUpdateTime, this.hostAvailabilityStrategy);
    }

    private void checkHostIsSet() {
        if (this.host == null) {
            throw new IllegalArgumentException("host parameter must be set.");
        }
    }
}

