/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.profile;

import com.zaxxer.hikari.HikariConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HikariPooledConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.plugin.AuroraConnectionTrackerPluginFactory;
import software.amazon.jdbc.plugin.AuroraHostListConnectionPluginFactory;
import software.amazon.jdbc.plugin.AuroraInitialConnectionStrategyPluginFactory;
import software.amazon.jdbc.plugin.efm2.HostMonitoringConnectionPlugin;
import software.amazon.jdbc.plugin.efm2.HostMonitoringConnectionPluginFactory;
import software.amazon.jdbc.plugin.failover.FailoverConnectionPluginFactory;
import software.amazon.jdbc.plugin.readwritesplitting.ReadWriteSplittingPluginFactory;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsPluginFactory;
import software.amazon.jdbc.profile.ConfigurationProfile;

public class DriverConfigurationProfiles {
    private static final Map<String, ConfigurationProfile> presets;
    private static final Map<String, ConfigurationProfile> activeProfiles;
    private static final String MONITORING_CONNECTION_PREFIX = "monitoring-";

    public static void clear() {
        activeProfiles.clear();
    }

    public static void addOrReplaceProfile(@NonNull String profileName, @NonNull ConfigurationProfile configurationProfile) {
        activeProfiles.put(profileName, configurationProfile);
    }

    public static void remove(@NonNull String profileName) {
        activeProfiles.remove(profileName);
    }

    public static boolean contains(@NonNull String profileName) {
        return activeProfiles.containsKey(profileName);
    }

    public static ConfigurationProfile getProfileConfiguration(@NonNull String profileName) {
        ConfigurationProfile profile = activeProfiles.get(profileName);
        if (profile != null) {
            return profile;
        }
        return presets.get(profileName);
    }

    private static Map<String, ConfigurationProfile> getConfigurationProfilePresets() {
        ConcurrentHashMap<String, ConfigurationProfile> presets = new ConcurrentHashMap<String, ConfigurationProfile>();
        presets.put("A0", new ConfigurationProfile("A0", Collections.emptyList(), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "5000", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("A1", new ConfigurationProfile("A1", Collections.emptyList(), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "30000", PropertyDefinition.SOCKET_TIMEOUT.name, "30000", PropertyDefinition.LOGIN_TIMEOUT.name, "30000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("A2", new ConfigurationProfile("A2", Collections.emptyList(), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "3000", PropertyDefinition.SOCKET_TIMEOUT.name, "3000", PropertyDefinition.LOGIN_TIMEOUT.name, "3000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("B", new ConfigurationProfile("B", Collections.emptyList(), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "true"), (Dialect)null, null, null, null, null));
        presets.put("C0", new ConfigurationProfile("C0", Collections.singletonList(HostMonitoringConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(HostMonitoringConnectionPlugin.FAILURE_DETECTION_TIME.name, "60000", HostMonitoringConnectionPlugin.FAILURE_DETECTION_COUNT.name, "5", HostMonitoringConnectionPlugin.FAILURE_DETECTION_INTERVAL.name, "15000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.CONNECT_TIMEOUT.name, "10000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.SOCKET_TIMEOUT.name, "5000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("C1", new ConfigurationProfile("C1", Collections.singletonList(HostMonitoringConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(HostMonitoringConnectionPlugin.FAILURE_DETECTION_TIME.name, "30000", HostMonitoringConnectionPlugin.FAILURE_DETECTION_COUNT.name, "3", HostMonitoringConnectionPlugin.FAILURE_DETECTION_INTERVAL.name, "5000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.CONNECT_TIMEOUT.name, "3000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.SOCKET_TIMEOUT.name, "3000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.LOGIN_TIMEOUT.name, "3000", PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("D0", new ConfigurationProfile("D0", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraInitialConnectionStrategyPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, ReadWriteSplittingPluginFactory.class, FailoverConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "5000", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), null, null, null, () -> new HikariPooledConnectionProvider((hostSpec, originalProps) -> {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(30);
            config.setMinimumIdle(2);
            config.setIdleTimeout(TimeUnit.MINUTES.toMillis(15L));
            config.setInitializationFailTimeout(-1L);
            config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(10L));
            config.setKeepaliveTime(TimeUnit.MINUTES.toMillis(3L));
            config.setValidationTimeout(TimeUnit.SECONDS.toMillis(1L));
            config.setMaxLifetime(TimeUnit.DAYS.toMillis(1L));
            return config;
        }, null), null));
        presets.put("D1", new ConfigurationProfile("D1", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraInitialConnectionStrategyPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, ReadWriteSplittingPluginFactory.class, FailoverConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "30000", PropertyDefinition.SOCKET_TIMEOUT.name, "30000", PropertyDefinition.LOGIN_TIMEOUT.name, "30000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), null, null, null, () -> new HikariPooledConnectionProvider((hostSpec, originalProps) -> {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(30);
            config.setMinimumIdle(2);
            config.setIdleTimeout(TimeUnit.MINUTES.toMillis(15L));
            config.setInitializationFailTimeout(-1L);
            config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(10L));
            config.setKeepaliveTime(TimeUnit.MINUTES.toMillis(3L));
            config.setValidationTimeout(TimeUnit.SECONDS.toMillis(1L));
            config.setMaxLifetime(TimeUnit.DAYS.toMillis(1L));
            return config;
        }, null), null));
        presets.put("E", new ConfigurationProfile("E", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraInitialConnectionStrategyPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, ReadWriteSplittingPluginFactory.class, FailoverConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "true"), null, null, null, () -> new HikariPooledConnectionProvider((hostSpec, originalProps) -> {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(30);
            config.setMinimumIdle(2);
            config.setIdleTimeout(TimeUnit.MINUTES.toMillis(15L));
            config.setInitializationFailTimeout(-1L);
            config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(10L));
            config.setKeepaliveTime(TimeUnit.MINUTES.toMillis(3L));
            config.setValidationTimeout(TimeUnit.SECONDS.toMillis(1L));
            config.setMaxLifetime(TimeUnit.DAYS.toMillis(1L));
            return config;
        }, null), null));
        presets.put("F0", new ConfigurationProfile("F0", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraInitialConnectionStrategyPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, ReadWriteSplittingPluginFactory.class, FailoverConnectionPluginFactory.class, HostMonitoringConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(HostMonitoringConnectionPlugin.FAILURE_DETECTION_TIME.name, "60000", HostMonitoringConnectionPlugin.FAILURE_DETECTION_COUNT.name, "5", HostMonitoringConnectionPlugin.FAILURE_DETECTION_INTERVAL.name, "15000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.CONNECT_TIMEOUT.name, "10000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.SOCKET_TIMEOUT.name, "5000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), null, null, null, () -> new HikariPooledConnectionProvider((hostSpec, originalProps) -> {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(30);
            config.setMinimumIdle(2);
            config.setIdleTimeout(TimeUnit.MINUTES.toMillis(15L));
            config.setInitializationFailTimeout(-1L);
            config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(10L));
            config.setKeepaliveTime(TimeUnit.MINUTES.toMillis(3L));
            config.setValidationTimeout(TimeUnit.SECONDS.toMillis(1L));
            config.setMaxLifetime(TimeUnit.DAYS.toMillis(1L));
            return config;
        }, null), null));
        presets.put("F1", new ConfigurationProfile("F1", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraInitialConnectionStrategyPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, ReadWriteSplittingPluginFactory.class, FailoverConnectionPluginFactory.class, HostMonitoringConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(HostMonitoringConnectionPlugin.FAILURE_DETECTION_TIME.name, "30000", HostMonitoringConnectionPlugin.FAILURE_DETECTION_COUNT.name, "3", HostMonitoringConnectionPlugin.FAILURE_DETECTION_INTERVAL.name, "5000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.CONNECT_TIMEOUT.name, "3000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.SOCKET_TIMEOUT.name, "3000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.LOGIN_TIMEOUT.name, "3000", PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), null, null, null, () -> new HikariPooledConnectionProvider((hostSpec, originalProps) -> {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(30);
            config.setMinimumIdle(2);
            config.setIdleTimeout(TimeUnit.MINUTES.toMillis(15L));
            config.setInitializationFailTimeout(-1L);
            config.setConnectionTimeout(TimeUnit.SECONDS.toMillis(10L));
            config.setKeepaliveTime(TimeUnit.MINUTES.toMillis(3L));
            config.setValidationTimeout(TimeUnit.SECONDS.toMillis(1L));
            config.setMaxLifetime(TimeUnit.DAYS.toMillis(1L));
            return config;
        }, null), null));
        presets.put("G0", new ConfigurationProfile("G0", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, AuroraStaleDnsPluginFactory.class, FailoverConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "5000", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("G1", new ConfigurationProfile("G1", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, AuroraStaleDnsPluginFactory.class, FailoverConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "30000", PropertyDefinition.SOCKET_TIMEOUT.name, "30000", PropertyDefinition.LOGIN_TIMEOUT.name, "30000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("H", new ConfigurationProfile("H", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, AuroraStaleDnsPluginFactory.class, FailoverConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "true"), (Dialect)null, null, null, null, null));
        presets.put("I0", new ConfigurationProfile("I0", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, AuroraStaleDnsPluginFactory.class, FailoverConnectionPluginFactory.class, HostMonitoringConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(HostMonitoringConnectionPlugin.FAILURE_DETECTION_TIME.name, "60000", HostMonitoringConnectionPlugin.FAILURE_DETECTION_COUNT.name, "5", HostMonitoringConnectionPlugin.FAILURE_DETECTION_INTERVAL.name, "15000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.CONNECT_TIMEOUT.name, "10000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.SOCKET_TIMEOUT.name, "5000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        presets.put("I1", new ConfigurationProfile("I1", Arrays.asList(AuroraHostListConnectionPluginFactory.class, AuroraConnectionTrackerPluginFactory.class, AuroraStaleDnsPluginFactory.class, FailoverConnectionPluginFactory.class, HostMonitoringConnectionPluginFactory.class), DriverConfigurationProfiles.getProperties(HostMonitoringConnectionPlugin.FAILURE_DETECTION_TIME.name, "30000", HostMonitoringConnectionPlugin.FAILURE_DETECTION_COUNT.name, "3", HostMonitoringConnectionPlugin.FAILURE_DETECTION_INTERVAL.name, "5000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.CONNECT_TIMEOUT.name, "3000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.SOCKET_TIMEOUT.name, "3000", MONITORING_CONNECTION_PREFIX + PropertyDefinition.LOGIN_TIMEOUT.name, "3000", PropertyDefinition.CONNECT_TIMEOUT.name, "10000", PropertyDefinition.SOCKET_TIMEOUT.name, "0", PropertyDefinition.LOGIN_TIMEOUT.name, "10000", PropertyDefinition.TCP_KEEP_ALIVE.name, "false"), (Dialect)null, null, null, null, null));
        return presets;
    }

    private static Properties getProperties(String ... args) {
        if (args == null) {
            return null;
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Properties should be passed by pairs: property name and property value.");
        }
        Properties props = new Properties();
        for (int i = 0; i < args.length; i += 2) {
            props.put(args[i], args[i + 1]);
        }
        return props;
    }

    static {
        activeProfiles = new ConcurrentHashMap<String, ConfigurationProfile>();
        presets = DriverConfigurationProfiles.getConfigurationProfilePresets();
    }
}

