/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.states;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.jdbc.states.SessionDirtyFlag;

public class SessionStateHelper {
    public void transferSessionState(EnumSet<SessionDirtyFlag> sessionState, Connection src, Connection dest) throws SQLException {
        if (src == null || dest == null) {
            return;
        }
        if (sessionState.contains((Object)SessionDirtyFlag.READONLY)) {
            dest.setReadOnly(src.isReadOnly());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.AUTO_COMMIT)) {
            dest.setAutoCommit(src.getAutoCommit());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.TRANSACTION_ISOLATION)) {
            dest.setTransactionIsolation(src.getTransactionIsolation());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.CATALOG)) {
            dest.setCatalog(src.getCatalog());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.SCHEMA)) {
            dest.setSchema(src.getSchema());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.TYPE_MAP)) {
            dest.setTypeMap(src.getTypeMap());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.HOLDABILITY)) {
            dest.setHoldability(src.getHoldability());
        }
        if (sessionState.contains((Object)SessionDirtyFlag.NETWORK_TIMEOUT)) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            dest.setNetworkTimeout(executorService, src.getNetworkTimeout());
            executorService.shutdown();
        }
    }

    public void restoreSessionState(Connection dest, Boolean readOnly, Boolean autoCommit) throws SQLException {
        if (dest == null) {
            return;
        }
        if (readOnly != null) {
            dest.setReadOnly(readOnly);
        }
        if (autoCommit != null) {
            dest.setAutoCommit(autoCommit);
        }
    }
}

