/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.util.WrapperUtils;

public class SQLInputWrapper
implements SQLInput {
    protected SQLInput sqlInput;
    protected ConnectionPluginManager pluginManager;

    public SQLInputWrapper(@NonNull SQLInput sqlInput, @NonNull ConnectionPluginManager pluginManager) {
        this.sqlInput = sqlInput;
        this.pluginManager = pluginManager;
    }

    @Override
    public String readString() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readString", () -> this.sqlInput.readString(), new Object[0]);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readBoolean", () -> this.sqlInput.readBoolean(), new Object[0]);
    }

    @Override
    public byte readByte() throws SQLException {
        return WrapperUtils.executeWithPlugins(Byte.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readByte", () -> this.sqlInput.readByte(), new Object[0]);
    }

    @Override
    public short readShort() throws SQLException {
        return WrapperUtils.executeWithPlugins(Short.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readShort", () -> this.sqlInput.readShort(), new Object[0]);
    }

    @Override
    public int readInt() throws SQLException {
        return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readInt", () -> this.sqlInput.readInt(), new Object[0]);
    }

    @Override
    public long readLong() throws SQLException {
        return WrapperUtils.executeWithPlugins(Long.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readLong", () -> this.sqlInput.readLong(), new Object[0]);
    }

    @Override
    public float readFloat() throws SQLException {
        return WrapperUtils.executeWithPlugins(Float.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readFloat", () -> Float.valueOf(this.sqlInput.readFloat()), new Object[0]).floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        return WrapperUtils.executeWithPlugins(Double.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readDouble", () -> this.sqlInput.readDouble(), new Object[0]);
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return WrapperUtils.executeWithPlugins(BigDecimal.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readBigDecimal", () -> this.sqlInput.readBigDecimal(), new Object[0]);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return WrapperUtils.executeWithPlugins(byte[].class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readBytes", () -> this.sqlInput.readBytes(), new Object[0]);
    }

    @Override
    public Date readDate() throws SQLException {
        return WrapperUtils.executeWithPlugins(Date.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readDate", () -> this.sqlInput.readDate(), new Object[0]);
    }

    @Override
    public Time readTime() throws SQLException {
        return WrapperUtils.executeWithPlugins(Time.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readTime", () -> this.sqlInput.readTime(), new Object[0]);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return WrapperUtils.executeWithPlugins(Timestamp.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readTimestamp", () -> this.sqlInput.readTimestamp(), new Object[0]);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return WrapperUtils.executeWithPlugins(Reader.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readCharacterStream", () -> this.sqlInput.readCharacterStream(), new Object[0]);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        return WrapperUtils.executeWithPlugins(InputStream.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readAsciiStream", () -> this.sqlInput.readAsciiStream(), new Object[0]);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return WrapperUtils.executeWithPlugins(InputStream.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readBinaryStream", () -> this.sqlInput.readBinaryStream(), new Object[0]);
    }

    @Override
    public Object readObject() throws SQLException {
        return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readObject", () -> this.sqlInput.readObject(), new Object[0]);
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return (T)WrapperUtils.executeWithPlugins(type, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readString", () -> this.sqlInput.readObject(type), type);
    }

    @Override
    public Ref readRef() throws SQLException {
        return WrapperUtils.executeWithPlugins(Ref.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readRef", () -> this.sqlInput.readRef(), new Object[0]);
    }

    @Override
    public Blob readBlob() throws SQLException {
        return WrapperUtils.executeWithPlugins(Blob.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readBlob", () -> this.sqlInput.readBlob(), new Object[0]);
    }

    @Override
    public Clob readClob() throws SQLException {
        return WrapperUtils.executeWithPlugins(Clob.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readClob", () -> this.sqlInput.readClob(), new Object[0]);
    }

    @Override
    public Array readArray() throws SQLException {
        return WrapperUtils.executeWithPlugins(Array.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readArray", () -> this.sqlInput.readArray(), new Object[0]);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return WrapperUtils.executeWithPlugins(Boolean.TYPE, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.wasNull", () -> this.sqlInput.wasNull(), new Object[0]);
    }

    @Override
    public URL readURL() throws SQLException {
        return WrapperUtils.executeWithPlugins(URL.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readURL", () -> this.sqlInput.readURL(), new Object[0]);
    }

    @Override
    public NClob readNClob() throws SQLException {
        return WrapperUtils.executeWithPlugins(NClob.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readNClob", () -> this.sqlInput.readNClob(), new Object[0]);
    }

    @Override
    public String readNString() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readNString", () -> this.sqlInput.readNString(), new Object[0]);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return WrapperUtils.executeWithPlugins(SQLXML.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readSQLXML", () -> this.sqlInput.readSQLXML(), new Object[0]);
    }

    @Override
    public RowId readRowId() throws SQLException {
        return WrapperUtils.executeWithPlugins(RowId.class, SQLException.class, this.pluginManager, this.sqlInput, "SQLInput.readRowId", () -> this.sqlInput.readRowId(), new Object[0]);
    }

    public String toString() {
        return super.toString() + " - " + this.sqlInput;
    }
}

