/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.postgresql.ds.common.BaseDataSource;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class PgDataSourceHelper {
    private static final Logger LOGGER = Logger.getLogger(PgDataSourceHelper.class.getName());
    private static final String BASE_DS_CLASS_NAME = BaseDataSource.class.getName();

    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        if (!(dataSource instanceof BaseDataSource)) {
            throw new SQLException(Messages.get("TargetDriverDialectManager.unexpectedClass", new Object[]{BASE_DS_CLASS_NAME, dataSource.getClass().getName()}));
        }
        BaseDataSource baseDataSource = (BaseDataSource)dataSource;
        baseDataSource.setDatabaseName(PropertyDefinition.DATABASE.getString(props));
        baseDataSource.setUser(PropertyDefinition.USER.getString(props));
        baseDataSource.setPassword(PropertyDefinition.PASSWORD.getString(props));
        baseDataSource.setServerNames(new String[]{hostSpec.getHost()});
        if (hostSpec.isPortSpecified()) {
            baseDataSource.setPortNumbers(new int[]{hostSpec.getPort()});
        }
        PropertyDefinition.removeAll(props);
        PropertyUtils.applyProperties(dataSource, props);
    }
}

