/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.PgDataSourceHelper;

public class PgTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    private static final String SIMPLE_DS_CLASS_NAME = "org.postgresql.ds.PGSimpleDataSource";
    private static final String POOLING_DS_CLASS_NAME = "org.postgresql.ds.PGPoolingDataSource";
    private static final String CP_DS_CLASS_NAME = "org.postgresql.ds.PGConnectionPoolDataSource";
    private static final Set<String> dataSourceClassMap = new HashSet<String>(Arrays.asList("org.postgresql.ds.PGSimpleDataSource", "org.postgresql.ds.PGPoolingDataSource", "org.postgresql.ds.PGConnectionPoolDataSource"));

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return dataSourceClassMap.contains(dataSourceClass);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        PgDataSourceHelper helper = new PgDataSourceHelper();
        helper.prepareDataSource(dataSource, hostSpec, props);
    }
}

