/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import software.amazon.jdbc.exceptions.ExceptionHandler;

public class PgExceptionHandler
implements ExceptionHandler {
    public static final List<String> NETWORK_ERRORS = Arrays.asList("53", "57P01", "57P02", "57P03", "58", "08", "99", "F0", "XX");
    public static final String ACCESS_ERROR = "28P01";

    @Override
    public boolean isNetworkException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (!(exception instanceof SQLException)) continue;
            return this.isNetworkException(((SQLException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        for (String pgSqlState : NETWORK_ERRORS) {
            if (!sqlState.startsWith(pgSqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (!(exception instanceof SQLException)) continue;
            return this.isLoginException(((SQLException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return ACCESS_ERROR.contains(sqlState);
    }
}

