/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import software.amazon.jdbc.dialect.PgDialect;
import software.amazon.jdbc.dialect.TopologyAwareDatabaseCluster;

public class AuroraPgDialect
extends PgDialect
implements TopologyAwareDatabaseCluster {
    private static final Logger LOGGER = Logger.getLogger(AuroraPgDialect.class.getName());
    private static final String extensionsSql = "SELECT (setting LIKE '%aurora_stat_utils%') AS aurora_stat_utils FROM pg_settings WHERE name='rds.extensions'";
    private static final String topologySql = "SELECT 1 FROM aurora_replica_status() LIMIT 1";

    @Override
    public String getTopologyQuery() {
        return "SELECT SERVER_ID, CASE WHEN SESSION_ID = 'MASTER_SESSION_ID' THEN TRUE ELSE FALSE END, CPU, COALESCE(REPLICA_LAG_IN_MSEC, 0) FROM aurora_replica_status() WHERE EXTRACT(EPOCH FROM(NOW() - LAST_UPDATE_TIMESTAMP)) <= 300 OR SESSION_ID = 'MASTER_SESSION_ID' ";
    }

    @Override
    public String getNodeIdQuery() {
        return "SELECT aurora_db_instance_identifier()";
    }

    @Override
    public String getIsReaderQuery() {
        return "SELECT pg_is_in_recovery()";
    }

    @Override
    public boolean isDialect(Connection connection) {
        if (!super.isDialect(connection)) {
            return false;
        }
        boolean hasExtensions = false;
        boolean hasTopology = false;
        try {
            Throwable throwable;
            ResultSet rs;
            try (Statement stmt = connection.createStatement();){
                rs = stmt.executeQuery(extensionsSql);
                throwable = null;
                try {
                    if (rs.next()) {
                        boolean auroraUtils = rs.getBoolean("aurora_stat_utils");
                        LOGGER.finest(() -> String.format("auroraUtils: %b", auroraUtils));
                        if (auroraUtils) {
                            hasExtensions = true;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            stmt = connection.createStatement();
            var5_6 = null;
            try {
                rs = stmt.executeQuery(topologySql);
                throwable = null;
                try {
                    if (rs.next()) {
                        LOGGER.finest(() -> "hasTopology: true");
                        hasTopology = true;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var5_6 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var5_6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var5_6.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            return hasExtensions && hasTopology;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

