/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.StringUtils;

public class RdsUtils {
    private static final Pattern AURORA_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-|cluster-|cluster-ro-|cluster-custom-)?(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com)", 2);
    private static final Pattern AURORA_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-|cluster-ro-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com)", 2);
    private static final Pattern AURORA_CUSTOM_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-custom-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com)", 2);
    private static final Pattern AURORA_PROXY_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-)+(?<domain>[a-zA-Z0-9]+\\.(?<region>[a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com)", 2);
    private static final Pattern AURORA_CHINA_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-|cluster-|cluster-ro-|cluster-custom-)?(?<domain>[a-zA-Z0-9]+\\.rds\\.(?<region>[a-zA-Z0-9\\-]+)\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern AURORA_CHINA_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-|cluster-ro-)+(?<domain>[a-zA-Z0-9]+\\.rds\\.(?<region>[a-zA-Z0-9\\-]+)\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern AURORA_CHINA_CUSTOM_CLUSTER_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>cluster-custom-)+(?<domain>[a-zA-Z0-9]+\\.rds\\.(?<region>[a-zA-Z0-9\\-]+)\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern AURORA_CHINA_PROXY_DNS_PATTERN = Pattern.compile("(?<instance>.+)\\.(?<dns>proxy-)+(?<domain>[a-zA-Z0-9]+\\.rds\\.(?<region>[a-zA-Z0-9\\-])+\\.amazonaws\\.com\\.cn)", 2);
    private static final Pattern IP_V4 = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IP_V6 = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IP_V6_COMPRESSED = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
    private static final String DNS_GROUP = "dns";
    private static final String DOMAIN_GROUP = "domain";
    private static final String REGION_GROUP = "region";

    public boolean isRdsClusterDns(String host) {
        return !StringUtils.isNullOrEmpty(host) && (AURORA_CLUSTER_PATTERN.matcher(host).find() || AURORA_CHINA_CLUSTER_PATTERN.matcher(host).find());
    }

    public boolean isRdsCustomClusterDns(String host) {
        return !StringUtils.isNullOrEmpty(host) && (AURORA_CUSTOM_CLUSTER_PATTERN.matcher(host).find() || AURORA_CHINA_CUSTOM_CLUSTER_PATTERN.matcher(host).find());
    }

    public boolean isRdsDns(String host) {
        return !StringUtils.isNullOrEmpty(host) && (AURORA_DNS_PATTERN.matcher(host).find() || AURORA_CHINA_DNS_PATTERN.matcher(host).find());
    }

    public boolean isRdsProxyDns(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return false;
        }
        return AURORA_PROXY_DNS_PATTERN.matcher(host).find() || AURORA_CHINA_PROXY_DNS_PATTERN.matcher(host).find();
    }

    public String getRdsInstanceHostPattern(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return "?";
        }
        Matcher matcher = AURORA_DNS_PATTERN.matcher(host);
        if (matcher.find()) {
            return "?." + matcher.group(DOMAIN_GROUP);
        }
        Matcher chinaMatcher = AURORA_CHINA_DNS_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return "?." + chinaMatcher.group(DOMAIN_GROUP);
        }
        return "?";
    }

    public String getRdsRegion(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return null;
        }
        Matcher matcher = AURORA_DNS_PATTERN.matcher(host);
        if (matcher.find()) {
            return matcher.group(REGION_GROUP);
        }
        Matcher chinaMatcher = AURORA_CHINA_DNS_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return chinaMatcher.group(REGION_GROUP);
        }
        return null;
    }

    public boolean isWriterClusterDns(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return false;
        }
        Matcher matcher = AURORA_CLUSTER_PATTERN.matcher(host);
        if (matcher.find()) {
            return "cluster-".equalsIgnoreCase(matcher.group(DNS_GROUP));
        }
        Matcher chinaMatcher = AURORA_CHINA_CLUSTER_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return "cluster-".equalsIgnoreCase(chinaMatcher.group(DNS_GROUP));
        }
        return false;
    }

    public boolean isReaderClusterDns(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return false;
        }
        Matcher matcher = AURORA_CLUSTER_PATTERN.matcher(host);
        if (matcher.find()) {
            return "cluster-ro-".equalsIgnoreCase(matcher.group(DNS_GROUP));
        }
        Matcher chinaMatcher = AURORA_CHINA_CLUSTER_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return "cluster-ro-".equalsIgnoreCase(chinaMatcher.group(DNS_GROUP));
        }
        return false;
    }

    public String getRdsClusterHostUrl(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return null;
        }
        Matcher matcher = AURORA_CLUSTER_PATTERN.matcher(host);
        if (matcher.find()) {
            return host.replaceAll(AURORA_CLUSTER_PATTERN.pattern(), "${instance}.cluster-${domain}");
        }
        Matcher chinaMatcher = AURORA_CHINA_CLUSTER_PATTERN.matcher(host);
        if (chinaMatcher.find()) {
            return host.replaceAll(AURORA_CHINA_CLUSTER_PATTERN.pattern(), "${instance}.cluster-${domain}");
        }
        return null;
    }

    public boolean isIPv4(String ip) {
        return !StringUtils.isNullOrEmpty(ip) && IP_V4.matcher(ip).matches();
    }

    public boolean isIPv6(String ip) {
        return !StringUtils.isNullOrEmpty(ip) && IP_V6.matcher(ip).matches() || IP_V6_COMPRESSED.matcher(ip).matches();
    }

    public boolean isDnsPatternValid(String pattern) {
        return pattern.contains("?");
    }

    public RdsUrlType identifyRdsType(String host) {
        if (StringUtils.isNullOrEmpty(host)) {
            return RdsUrlType.OTHER;
        }
        if (this.isIPv4(host) || this.isIPv6(host)) {
            return RdsUrlType.IP_ADDRESS;
        }
        if (this.isWriterClusterDns(host)) {
            return RdsUrlType.RDS_WRITER_CLUSTER;
        }
        if (this.isReaderClusterDns(host)) {
            return RdsUrlType.RDS_READER_CLUSTER;
        }
        if (this.isRdsCustomClusterDns(host)) {
            return RdsUrlType.RDS_CUSTOM_CLUSTER;
        }
        if (this.isRdsProxyDns(host)) {
            return RdsUrlType.RDS_PROXY;
        }
        if (this.isRdsDns(host)) {
            return RdsUrlType.RDS_INSTANCE;
        }
        return RdsUrlType.OTHER;
    }
}

