/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpiringCache<K, V>
implements Map<K, V> {
    private long expireTimeMs;
    private @Nullable OnEvictRunnable<V> onEvictRunnable;
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private final LinkedHashMap<K, Hit<V>> linkedHashMap = new LinkedHashMap<K, Hit<V>>(1, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Hit<V>> eldest) {
            if (eldest.getValue().isExpire(ExpiringCache.this.expireTimeMs)) {
                Iterator i = this.values().iterator();
                while (i.hasNext()) {
                    Hit hit = (Hit)i.next();
                    if (!hit.isExpire(ExpiringCache.this.expireTimeMs)) continue;
                    i.remove();
                    if (ExpiringCache.this.onEvictRunnable == null) continue;
                    try {
                        ExpiringCache.this.onEvictRunnable.call(hit.payload);
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }
    };

    public ExpiringCache(long expireTimeMs) {
        this.expireTimeMs = expireTimeMs;
    }

    public ExpiringCache(long expireTimeMs, @Nullable OnEvictRunnable<V> onEvictRunnable) {
        this.expireTimeMs = expireTimeMs;
        this.onEvictRunnable = onEvictRunnable;
    }

    public void setExpireTime(long expireTimeMs) {
        this.expireTimeMs = expireTimeMs;
    }

    public long getExpireTime() {
        return this.expireTimeMs;
    }

    @Override
    public int size() {
        try {
            this.reentrantLock.lock();
            int n = (int)this.linkedHashMap.values().stream().filter(x -> !x.isExpire(this.expireTimeMs)).count();
            return n;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.reentrantLock.lock();
            boolean bl = !this.linkedHashMap.values().stream().anyMatch(x -> !x.isExpire(this.expireTimeMs));
            return bl;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        try {
            this.reentrantLock.lock();
            V payload = this.get(key);
            boolean bl = payload != null;
            return bl;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            this.reentrantLock.lock();
            boolean bl = this.linkedHashMap.values().stream().anyMatch(x -> !x.isExpire(this.expireTimeMs) && ((Hit)x).payload == value);
            return bl;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V get(Object key) {
        try {
            this.reentrantLock.lock();
            Hit<V> hit = this.linkedHashMap.get(key);
            if (hit == null) {
                V v = null;
                return v;
            }
            if (hit.isExpire(this.expireTimeMs)) {
                this.linkedHashMap.remove(key);
                V v = null;
                return v;
            }
            Object object = ((Hit)hit).payload;
            return (V)object;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V put(K key, V value) {
        try {
            this.reentrantLock.lock();
            Hit<V> prevValue = this.linkedHashMap.put(key, new Hit<V>(value));
            Object object = prevValue == null ? null : ((Hit)prevValue).payload;
            return (V)object;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V remove(Object key) {
        try {
            this.reentrantLock.lock();
            Hit prevValue = (Hit)this.linkedHashMap.remove(key);
            Object object = prevValue == null ? null : prevValue.payload;
            return (V)object;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.reentrantLock.lock();
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.linkedHashMap.put(entry.getKey(), new Hit<V>(entry.getValue()));
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.reentrantLock.lock();
            this.linkedHashMap.clear();
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public Set<@KeyFor(value={"this"}) K> keySet() {
        try {
            this.reentrantLock.lock();
            Set set = this.linkedHashMap.entrySet().stream().filter(x -> !((Hit)x.getValue()).isExpire(this.expireTimeMs)).map(Map.Entry::getKey).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        try {
            this.reentrantLock.lock();
            Collection collection = this.linkedHashMap.values().stream().filter(x -> !x.isExpire(this.expireTimeMs)).map(x -> ((Hit)x).payload).collect(Collectors.toList());
            return collection;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet() {
        try {
            this.reentrantLock.lock();
            Set<Map.Entry<K, V>> set = this.linkedHashMap.entrySet().stream().filter(x -> !((Hit)x.getValue()).isExpire(this.expireTimeMs)).map(x -> new AbstractMap.SimpleEntry(x.getKey(), ((Hit)x.getValue()).payload)).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public void setOnEvictRunnable(OnEvictRunnable<V> onEvictRunnable) {
        try {
            this.reentrantLock.lock();
            this.onEvictRunnable = onEvictRunnable;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public ReentrantLock getLock() {
        return this.reentrantLock;
    }

    public static interface OnEvictRunnable<V> {
        public void call(V var1);
    }

    private static class Hit<V> {
        private final long time = System.nanoTime();
        private final V payload;

        Hit(V payload) {
            this.payload = payload;
        }

        boolean isExpire(long expireTimeMs) {
            long elapsedTimeNano = System.nanoTime() - this.time;
            return elapsedTimeNano >= TimeUnit.MILLISECONDS.toNanos(expireTimeMs);
        }
    }
}

