/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;

public class ConnectionUrlBuilder {
    public static String buildUrl(String jdbcProtocol, HostSpec hostSpec, String serverPropertyName, String portPropertyName, String databasePropertyName, Properties props) throws SQLException {
        if (StringUtils.isNullOrEmpty(jdbcProtocol) || (StringUtils.isNullOrEmpty(serverPropertyName) || StringUtils.isNullOrEmpty(props.getProperty(serverPropertyName))) && hostSpec == null) {
            throw new SQLException(Messages.get("ConnectionUrlBuilder.missingJdbcProtocol"));
        }
        Properties copy = PropertyUtils.copyProperties(props);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(jdbcProtocol);
        if (!jdbcProtocol.contains("//")) {
            urlBuilder.append("//");
        }
        if (hostSpec != null) {
            urlBuilder.append(hostSpec.getUrl());
        } else {
            urlBuilder.append(copy.get(serverPropertyName));
            if (!StringUtils.isNullOrEmpty(portPropertyName) && !StringUtils.isNullOrEmpty(copy.getProperty(portPropertyName))) {
                urlBuilder.append(":").append(copy.get(portPropertyName));
            }
            urlBuilder.append("/");
        }
        if (!StringUtils.isNullOrEmpty(PropertyDefinition.DATABASE.getString(copy))) {
            urlBuilder.append(PropertyDefinition.DATABASE.getString(copy));
            copy.remove(PropertyDefinition.DATABASE.name);
        }
        ConnectionUrlBuilder.removeProperty(serverPropertyName, copy);
        ConnectionUrlBuilder.removeProperty(portPropertyName, copy);
        ConnectionUrlBuilder.removeProperty(databasePropertyName, copy);
        StringBuilder queryBuilder = new StringBuilder();
        Enumeration<?> propertyNames = copy.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement().toString();
            if (queryBuilder.length() != 0) {
                queryBuilder.append("&");
            }
            String propertyValue = copy.getProperty(propertyName);
            try {
                queryBuilder.append(propertyName).append("=").append(URLEncoder.encode(propertyValue, StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(Messages.get("ConnectionUrlBuilder.failureEncodingConnectionUrl"), e);
            }
        }
        if (queryBuilder.length() != 0) {
            urlBuilder.append("?").append((CharSequence)queryBuilder);
        }
        return urlBuilder.toString();
    }

    private static void removeProperty(String propertyKey, Properties props) {
        if (!StringUtils.isNullOrEmpty(propertyKey) && !StringUtils.isNullOrEmpty(props.getProperty(propertyKey))) {
            props.remove(propertyKey);
        }
    }
}

