/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.system;

import java.io.InputStream;
import java.io.Reader;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonValue;
import software.amazon.ion.impl.PrivateIonReaderFactory;
import software.amazon.ion.system.SimpleCatalog;

public class IonReaderBuilder {
    private IonCatalog catalog = null;

    private IonReaderBuilder() {
    }

    private IonReaderBuilder(IonReaderBuilder that) {
        this.catalog = that.catalog;
    }

    public static IonReaderBuilder standard() {
        return new Mutable();
    }

    public IonReaderBuilder copy() {
        return new Mutable(this);
    }

    public IonReaderBuilder immutable() {
        return this;
    }

    public IonReaderBuilder mutable() {
        return this.copy();
    }

    protected void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public IonReaderBuilder withCatalog(IonCatalog catalog) {
        IonReaderBuilder b = this.mutable();
        b.setCatalog(catalog);
        return b;
    }

    public void setCatalog(IonCatalog catalog) {
        this.mutationCheck();
        this.catalog = catalog;
    }

    public IonCatalog getCatalog() {
        return this.catalog;
    }

    private IonCatalog validateCatalog() {
        return this.catalog != null ? this.catalog : new SimpleCatalog();
    }

    public IonReader build(byte[] ionData) {
        return PrivateIonReaderFactory.makeReader(this.validateCatalog(), ionData);
    }

    public IonReader build(byte[] ionData, int offset, int length) {
        return PrivateIonReaderFactory.makeReader(this.validateCatalog(), ionData, offset, length);
    }

    public IonReader build(InputStream ionData) {
        return PrivateIonReaderFactory.makeReader(this.validateCatalog(), ionData);
    }

    public IonReader build(Reader ionText) {
        return PrivateIonReaderFactory.makeReader(this.validateCatalog(), ionText);
    }

    public IonReader build(IonValue value) {
        return PrivateIonReaderFactory.makeReader(this.validateCatalog(), value);
    }

    public IonReader build(String ionText) {
        return PrivateIonReaderFactory.makeReader(this.validateCatalog(), ionText);
    }

    private static class Mutable
    extends IonReaderBuilder {
        private Mutable() {
        }

        private Mutable(IonReaderBuilder that) {
            super(that);
        }

        @Override
        public IonReaderBuilder immutable() {
            return new IonReaderBuilder(this);
        }

        @Override
        public IonReaderBuilder mutable() {
            return this;
        }

        @Override
        protected void mutationCheck() {
        }
    }
}

